/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.vm;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.WebUtils;
import org.gluu.casa.plugins.accounts.pojo.LinkingSummary;
import org.gluu.casa.plugins.accounts.pojo.PendingLinks;
import org.gluu.casa.service.ISessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class PostAccountLinkingViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private ObjectMapper mapper = new ObjectMapper();
    private String title;
    private String text;

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    @Init
    public void init(@QueryParam(value="provider") String provider) {
        try {
            this.logger.debug("Initializing ViewModel");
            this.title = Labels.getLabel((String)"general.error.general");
            String userId = Optional.ofNullable(this.sessionContext.getLoggedUser()).map(User::getId).orElse(null);
            LinkingSummary summary = PendingLinks.get(userId, provider);
            if (summary != null) {
                String uid = summary.getUid();
                if (uid != null) {
                    this.logger.warn("Notifying linking page...");
                    EventQueues.lookup((String)"social_queue", (String)"session", (boolean)true).publish(new Event("linked", null, (Object)summary));
                    this.title = Labels.getLabel((String)"sociallogin.linking_result.success");
                    this.text = Labels.getLabel((String)"sociallogin.linking_result.success_close");
                } else {
                    this.text = summary.getErrorMessage();
                }
                this.expirePassportCookie(provider);
            } else {
                this.logger.warn("No linking is pending for provider {} and user {}", (Object)provider, (Object)userId);
            }
        }
        catch (Exception e) {
            this.text = e.getMessage();
            this.logger.error(this.text, (Throwable)e);
        }
    }

    private void expirePassportCookie(String provider) {
        Cookie coo = new Cookie("casa-" + provider, "");
        coo.setPath("/");
        coo.setSecure(true);
        coo.setHttpOnly(true);
        coo.setMaxAge(0);
        WebUtils.getServletResponse().addCookie(coo);
    }
}

