/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.service;

import java.util.ArrayList;
import java.util.List;
import org.gluu.casa.core.model.IdentityPerson;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.accounts.pojo.ExternalAccount;
import org.gluu.casa.plugins.accounts.pojo.Provider;
import org.gluu.casa.plugins.accounts.service.AvailableProviders;
import org.gluu.casa.service.IPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountLinkingService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);

    public List<ExternalAccount> getAccounts(String id, boolean linked) {
        ArrayList<ExternalAccount> externalAccts = new ArrayList<ExternalAccount>();
        IdentityPerson p = this.getPerson(id);
        for (Provider provider : AvailableProviders.get()) {
            String uid = provider.getEnrollmentManager().getUid(p, linked);
            if (uid == null) continue;
            ExternalAccount acc = new ExternalAccount();
            acc.setProvider(provider);
            acc.setUid(uid);
            externalAccts.add(acc);
        }
        return externalAccts;
    }

    public boolean link(String id, String provider, String externalId) {
        IdentityPerson p = this.getPerson(id);
        Provider op = AvailableProviders.get(provider).get();
        return op.getEnrollmentManager().link(p, externalId);
    }

    public boolean unlink(String id, Provider provider) {
        return provider.getEnrollmentManager().unlink(this.getPerson(id));
    }

    public boolean enableLink(String id, Provider provider) {
        return provider.getEnrollmentManager().enable(this.getPerson(id));
    }

    public boolean delete(String id, Provider provider) {
        return provider.getEnrollmentManager().remove(this.getPerson(id));
    }

    public boolean hasPassword(String id) {
        return this.getPerson(id).hasPassword();
    }

    private IdentityPerson getPerson(String id) {
        return (IdentityPerson)this.persistenceService.get(IdentityPerson.class, this.persistenceService.getPersonDn(id));
    }
}

