/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.service.enrollment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gluu.casa.core.model.IdentityPerson;
import org.gluu.casa.plugins.accounts.pojo.Provider;
import org.gluu.casa.plugins.accounts.service.enrollment.AbstractEnrollmentManager;
import org.zkoss.util.Pair;

public class SocialEnrollmentManager
extends AbstractEnrollmentManager {
    private static final String OXEXTERNALUID_PREFIX = "passport-";

    public SocialEnrollmentManager(Provider provider) {
        super(provider);
    }

    @Override
    public String getUid(IdentityPerson p, boolean linked) {
        List list = linked ? p.getOxExternalUid() : p.getOxUnlinkedExternalUids();
        for (String externalUid : list) {
            String prv;
            int i;
            if (!externalUid.startsWith(OXEXTERNALUID_PREFIX) || (i = externalUid.indexOf(":")) <= OXEXTERNALUID_PREFIX.length() || !(prv = externalUid.substring(OXEXTERNALUID_PREFIX.length(), i)).equals(this.provider.getId())) continue;
            return externalUid.substring(i + 1);
        }
        return null;
    }

    @Override
    public boolean link(IdentityPerson p, String externalId) {
        HashSet<String> set = new HashSet<String>(p.getOxExternalUid());
        set.add(this.getFormatedAttributeVal(externalId));
        this.logger.info("Linked accounts for {} will be {}", (Object)p.getUid(), set);
        p.setOxExternalUid(new ArrayList(set));
        return this.updatePerson(p);
    }

    @Override
    public boolean remove(IdentityPerson p) {
        this.logger.info("Removing provider {} for {}", (Object)this.provider.getDisplayName(), (Object)p.getUid());
        List linked = (List)SocialEnrollmentManager.removeProvider(this.provider, p.getOxExternalUid()).getY();
        List unlinked = (List)SocialEnrollmentManager.removeProvider(this.provider, p.getOxUnlinkedExternalUids()).getY();
        return this.updateExternalIdentities(p, linked, unlinked);
    }

    @Override
    public boolean unlink(IdentityPerson p) {
        boolean success = false;
        Pair<String, List<String>> tmp = SocialEnrollmentManager.removeProvider(this.provider, p.getOxExternalUid());
        List linked = (List)tmp.getY();
        String oxExternalUid = (String)tmp.getX();
        if (oxExternalUid != null) {
            ArrayList<String> unlinked = new ArrayList<String>(p.getOxUnlinkedExternalUids());
            unlinked.add(oxExternalUid);
            this.logger.info("Linked accounts for {} will be {}", (Object)p.getUid(), (Object)linked);
            this.logger.info("Unlinked accounts for {} will be {}", (Object)p.getUid(), unlinked);
            success = this.updateExternalIdentities(p, linked, unlinked);
        }
        return success;
    }

    @Override
    public boolean enable(IdentityPerson p) {
        boolean success = false;
        Pair<String, List<String>> tmp = SocialEnrollmentManager.removeProvider(this.provider, p.getOxUnlinkedExternalUids());
        List unlinked = (List)tmp.getY();
        String oxExternalUid = (String)tmp.getX();
        if (oxExternalUid != null) {
            ArrayList<String> linked = new ArrayList<String>(p.getOxExternalUid());
            linked.add(oxExternalUid);
            this.logger.info("Linked accounts for {} will be {}", (Object)p.getUid(), linked);
            this.logger.info("Unlinked accounts for {} will be {}", (Object)p.getUid(), (Object)unlinked);
            success = this.updateExternalIdentities(p, linked, unlinked);
        }
        return success;
    }

    private static Pair<String, List<String>> removeProvider(Provider provider, List<String> externalUids) {
        ArrayList<String> list = new ArrayList<String>();
        String oxExternalUid = null;
        for (String externalUid : externalUids) {
            if (externalUid.startsWith(OXEXTERNALUID_PREFIX)) {
                int i = externalUid.indexOf(":");
                if (i <= OXEXTERNALUID_PREFIX.length()) continue;
                String prv = externalUid.substring(OXEXTERNALUID_PREFIX.length(), i);
                if (prv.equals(provider.getId())) {
                    oxExternalUid = externalUid;
                    continue;
                }
                list.add(externalUid);
                continue;
            }
            list.add(externalUid);
        }
        return new Pair(oxExternalUid, list);
    }

    private boolean updateExternalIdentities(IdentityPerson p, List<String> linked, List<String> unlinked) {
        p.setOxExternalUid(linked);
        p.setOxUnlinkedExternalUids(unlinked);
        return this.updatePerson(p);
    }

    @Override
    public boolean isAssigned(String uid) {
        IdentityPerson p = new IdentityPerson();
        p.setOxExternalUid(Collections.singletonList(this.getFormatedAttributeVal(uid)));
        p.setBaseDn(persistenceService.getPeopleDn());
        return persistenceService.count((Object)p) > 0;
    }

    private String getFormatedAttributeVal(String uid) {
        return String.format("passport-%s:%s", this.provider.getId(), uid);
    }
}

