/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.service.enrollment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gluu.casa.core.model.IdentityPerson;
import org.gluu.casa.plugins.accounts.pojo.Provider;
import org.gluu.casa.plugins.accounts.service.enrollment.AbstractEnrollmentManager;

public class SamlEnrollmentManager
extends AbstractEnrollmentManager {
    private static final String OXEXTERNALUID_PREFIX = "passport-saml:";

    public SamlEnrollmentManager(Provider provider) {
        super(provider);
    }

    @Override
    public String getUid(IdentityPerson p, boolean linked) {
        List list = linked ? p.getOxExternalUid() : p.getOxUnlinkedExternalUids();
        for (String externalUid : list) {
            int i;
            if (!externalUid.startsWith(OXEXTERNALUID_PREFIX) || (i = externalUid.lastIndexOf(":")) <= OXEXTERNALUID_PREFIX.length() || i >= externalUid.length() - 1) continue;
            String providerId = externalUid.substring(OXEXTERNALUID_PREFIX.length(), i);
            if (!this.provider.getId().equals(providerId)) continue;
            return externalUid.substring(i + 1);
        }
        return null;
    }

    @Override
    public boolean link(IdentityPerson p, String externalId) {
        ArrayList<String> list = new ArrayList<String>(p.getOxExternalUid());
        list.add(this.getFormattedAttributeVal(externalId));
        this.logger.info("Linked accounts for {} will be {}", (Object)p.getUid(), list);
        p.setOxExternalUid(list);
        return this.updatePerson(p);
    }

    @Override
    public boolean remove(IdentityPerson p) {
        this.removeProvider(p);
        return this.updatePerson(p);
    }

    @Override
    public boolean unlink(IdentityPerson p) {
        String uid = this.removeProvider(p);
        if (uid == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>(p.getOxUnlinkedExternalUids());
        list.add(this.getFormattedAttributeVal(uid));
        p.setOxUnlinkedExternalUids(list);
        return this.updatePerson(p);
    }

    @Override
    public boolean enable(IdentityPerson p) {
        String uid = this.removeProvider(p);
        if (uid == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>(p.getOxExternalUid());
        list.add(this.getFormattedAttributeVal(uid));
        p.setOxExternalUid(list);
        return this.updatePerson(p);
    }

    @Override
    public boolean isAssigned(String uid) {
        IdentityPerson p = new IdentityPerson();
        p.setOxExternalUid(Collections.singletonList(this.getFormattedAttributeVal(uid)));
        p.setBaseDn(persistenceService.getPeopleDn());
        return persistenceService.count((Object)p) > 0;
    }

    private String removeProvider(IdentityPerson p) {
        String pattern = String.format("%s%s:", OXEXTERNALUID_PREFIX, this.provider.getId());
        HashSet externalUids = new HashSet(p.getOxExternalUid());
        HashSet unlinkedUids = new HashSet(p.getOxUnlinkedExternalUids());
        String externalUid = externalUids.stream().filter(str -> str.startsWith(pattern)).findFirst().map(str -> str.substring(pattern.length())).orElse("");
        if (externalUid.length() == 0) {
            externalUid = unlinkedUids.stream().filter(str -> str.startsWith(pattern)).findFirst().map(str -> str.substring(pattern.length())).orElse("");
        }
        if (externalUid.length() > 0) {
            String str2 = this.getFormattedAttributeVal(externalUid);
            externalUids.remove(str2);
            unlinkedUids.remove(str2);
        } else {
            externalUid = null;
        }
        p.setOxExternalUid(new ArrayList(externalUids));
        p.setOxUnlinkedExternalUids(new ArrayList(unlinkedUids));
        return externalUid;
    }

    private String getFormattedAttributeVal(String uid) {
        return String.format("passport-saml:%s:%s", this.provider.getId(), uid);
    }
}

