/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.config.oxtrust.LdapOxPassportConfiguration;
import org.gluu.model.passport.PassportConfiguration;
import org.gluu.model.passport.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableProviders {
    private static final String CONFIG_FILE = "/etc/gluu/conf/gluu.properties";
    private static final String OXPASSPORT_PROPERTY = "oxpassport_ConfigurationEntryDN";
    private static List<org.gluu.casa.plugins.accounts.pojo.Provider> providers;
    private static Logger logger;
    private static IPersistenceService persistenceService;

    public static List<org.gluu.casa.plugins.accounts.pojo.Provider> get() {
        return AvailableProviders.get(false);
    }

    public static List<org.gluu.casa.plugins.accounts.pojo.Provider> get(boolean refresh) {
        if (refresh) {
            providers = AvailableProviders.retrieveProviders();
        }
        return providers;
    }

    public static Optional<org.gluu.casa.plugins.accounts.pojo.Provider> get(String id) {
        return providers.stream().filter(p -> p.getId().equals(id)).findFirst();
    }

    private static List<org.gluu.casa.plugins.accounts.pojo.Provider> retrieveProviders() {
        ArrayList<org.gluu.casa.plugins.accounts.pojo.Provider> providers = new ArrayList<org.gluu.casa.plugins.accounts.pojo.Provider>();
        logger.info("Loading providers info");
        try {
            logger.debug("Reading DN of passport configuration");
            Path path = Paths.get(CONFIG_FILE, new String[0]);
            if (path == null) {
                throw new IOException("No configuration file found in /etc/gluu/conf");
            }
            String dn = Files.newBufferedReader(path).lines().filter(l -> l.startsWith(OXPASSPORT_PROPERTY)).findFirst().map(l -> l.substring(OXPASSPORT_PROPERTY.length())).get();
            dn = dn.replaceFirst("[\\W]*=[\\W]*", "");
            List details = Optional.ofNullable((LdapOxPassportConfiguration)persistenceService.get(LdapOxPassportConfiguration.class, dn)).map(LdapOxPassportConfiguration::getPassportConfiguration).map(PassportConfiguration::getProviders).orElse(Collections.emptyList());
            details = details.stream().filter(Provider::isEnabled).collect(Collectors.toList());
            logger.info("Found {} enabled providers", (Object)details.size());
            for (Provider p : details) {
                org.gluu.casa.plugins.accounts.pojo.Provider provider = new org.gluu.casa.plugins.accounts.pojo.Provider(p);
                if (provider.getDisplayName() == null) {
                    provider.setDisplayName(p.getId());
                }
                logger.info("Found provider {}", (Object)provider.getDisplayName());
                String logo = provider.getLogoImg();
                if (logo != null && !logo.startsWith("http")) {
                    logo = "/oxauth/auth/passport/" + logo;
                }
                provider.setLogoImg(logo);
                providers.add(provider);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return providers;
    }

    static {
        logger = LoggerFactory.getLogger(AvailableProviders.class);
        persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
        providers = AvailableProviders.retrieveProviders();
    }
}

