/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.vm;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.misc.WebUtils;
import org.gluu.casa.service.IPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class SiteRedirectViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private IPersistenceService persistenceService;
    private ObjectMapper mapper = new ObjectMapper();
    private String serverUrl;
    private String text;

    public String getText() {
        return this.text;
    }

    @Init
    public void init(@QueryParam(value="provider") String provider) {
        this.logger.debug("Initializing ViewModel");
        this.text = Labels.getLabel((String)"sociallogin.link_redirect_failed", (Object[])new String[]{provider});
        if (Utils.isNotEmpty((String)provider)) {
            this.serverUrl = this.persistenceService.getIssuerUrl();
            String url = this.getRedirectUrl(provider);
            if (url != null) {
                WebUtils.execRedirect((String)url, (boolean)false);
            }
        }
    }

    private String getRedirectUrl(String provider) {
        this.logger.info("Building a passport redirect URL to start with linking process");
        String token = this.getPassportToken();
        return Utils.isEmpty((String)token) ? null : String.format("%s/passport/casa/%s/%s", this.serverUrl, provider, token);
    }

    private String getPassportToken() {
        try {
            String url = String.format("%s/passport/token", this.serverUrl);
            this.logger.info("Requesting token at {}", (Object)url);
            return this.mapper.readTree(new URL(url)).get("token_").asText();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

