/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gluu.casa.core.model.CustomScript;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.accounts.pojo.LinkingSummary;
import org.gluu.casa.plugins.accounts.pojo.PassportScriptProperties;
import org.gluu.casa.plugins.accounts.pojo.PendingLinks;
import org.gluu.casa.plugins.accounts.pojo.Provider;
import org.gluu.casa.plugins.accounts.pojo.ProviderType;
import org.gluu.casa.plugins.accounts.service.AvailableProviders;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.casa.service.ISessionContext;
import org.gluu.oxauth.model.common.WebKeyStorage;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.CryptoProviderFactory;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.resource.Labels;
import org.zkoss.web.servlet.http.Encodes;

@Path(value="/idp-linking")
public class PassportLinkingService {
    private static final String SALT_FILE = "/etc/gluu/conf/salt";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();
    private Map<ProviderType, PassportScriptProperties> passportProperties;
    private StringEncrypter stringEncrypter;
    @Context
    private UriInfo uriInfo;

    public PassportLinkingService() {
        try {
            this.logger.info("Creating an instance of PassportLinkingService");
            this.mapper = new ObjectMapper();
            IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
            this.stringEncrypter = Utils.stringEncrypter((String)SALT_FILE);
            this.passportProperties = new HashMap<ProviderType, PassportScriptProperties>();
            for (ProviderType pt : ProviderType.values()) {
                PassportScriptProperties psp = new PassportScriptProperties();
                CustomScript script = new CustomScript();
                script.setDisplayName(pt.getAcr());
                script.setBaseDn(persistenceService.getCustomScriptsDn());
                List list = persistenceService.find((Object)script);
                CustomScript customScript = script = list.size() > 0 ? (CustomScript)list.get(0) : null;
                if (script == null) continue;
                Map props = Utils.scriptConfigPropertiesAsMap((CustomScript)script);
                psp.setKeyStoreFile((String)props.get("key_store_file"));
                psp.setKeyStorePassword((String)props.get("key_store_password"));
                this.passportProperties.put(pt, psp);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.warn("Service for linking external identities may not work properly");
        }
    }

    @GET
    public Response processError(@QueryParam(value="failure") String msg) throws Exception {
        this.logger.warn("An error occurred: {}", (Object)msg);
        return Response.serverError().entity((Object)msg).build();
    }

    @POST
    @Path(value="{provider}")
    public Response doLink(@FormParam(value="user") String userJwt, @PathParam(value="provider") String provider) throws Exception {
        LinkingSummary summary = new LinkingSummary();
        String msg = null;
        ISessionContext sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
        String userId = Optional.ofNullable(sessionContext.getLoggedUser()).map(User::getId).orElse(null);
        this.logger.info("Linking provider {} to user {} ...", (Object)provider, (Object)userId);
        try {
            if (userId == null) {
                msg = Labels.getLabel((String)"sociallogin.link_result.session_lost");
                this.logger.warn(msg);
            } else if (PendingLinks.contains(userId, provider)) {
                Provider prv = AvailableProviders.get().stream().filter(p -> p.getId().equals(provider)).findFirst().get();
                PassportScriptProperties psp = this.passportProperties.get((Object)prv.getScriptType());
                Jwt jwt = this.validateJWT(userJwt, psp);
                if (jwt != null) {
                    this.logger.info("user profile JWT validated successfully");
                    this.logger.trace("JWT = {}", (Object)jwt);
                    String profile = jwt.getClaims().getClaimAsString("data");
                    this.logger.info("decrypting profile...");
                    profile = this.stringEncrypter.decrypt(profile);
                    String uid = this.mapper.readTree(profile).get("uid").get(0).asText();
                    if (!prv.getEnrollmentManager().isAssigned(uid)) {
                        summary.setProvider(provider);
                        summary.setUid(uid);
                    } else {
                        msg = Labels.getLabel((String)"sociallogin.link_result.already_taken", (Object[])new String[]{uid, provider});
                        this.logger.warn(msg);
                    }
                } else {
                    msg = Labels.getLabel((String)"sociallogin.link_result.validation_failed");
                    this.logger.error(msg);
                }
            } else {
                msg = Labels.getLabel((String)"sociallogin.link_result.unexpected_provider", (Object[])new String[]{provider});
                this.logger.warn(msg);
            }
        }
        catch (Exception e) {
            msg = e.getMessage();
            this.logger.error(msg, (Throwable)e);
        }
        if (msg != null) {
            summary.setErrorMessage(msg);
        }
        String url = this.uriInfo.getAbsolutePath().toString();
        url = url + "/../../account-linking-result.zul?provider=" + Encodes.encodeURIComponent((String)provider);
        URI uri = new URL(url.replaceFirst("/rest", "")).toURI();
        PendingLinks.add(userId, provider, summary);
        this.logger.debug("Redirecting to {}", (Object)uri.toString());
        return Response.seeOther((URI)uri).build();
    }

    private Jwt validateJWT(String encodedJWT, PassportScriptProperties properties) {
        try {
            Jwt jwt = Jwt.parse((String)encodedJWT);
            AppConfiguration appCfg = new AppConfiguration();
            appCfg.setWebKeysStorage(WebKeyStorage.KEYSTORE);
            appCfg.setKeyStoreFile(properties.getKeyStoreFile());
            appCfg.setKeyStoreSecret(properties.getKeyStorePassword());
            appCfg.setKeyRegenerationEnabled(Boolean.valueOf(false));
            return CryptoProviderFactory.getCryptoProvider((AppConfiguration)appCfg).verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), null, null, jwt.getHeader().getAlgorithm()) ? jwt : null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

