/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.ui;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.gluu.casa.misc.WebUtils;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;

public class CustomDateConverter
implements Converter {
    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        long timeStamp;
        long l = timeStamp = val instanceof Date ? ((Date)val).getTime() : ((Long)val).longValue();
        if (timeStamp > 0L) {
            Locale locale;
            ZoneId zid;
            Object format = (String)ctx.getConverterArg("format");
            Object offset = ctx.getConverterArg("offset");
            if (offset != null && ZoneId.class.isAssignableFrom(offset.getClass())) {
                zid = (ZoneId)offset;
            } else {
                zid = ZoneOffset.UTC;
                if (((String)format).contains("hh") || ((String)format).contains("HH") || ((String)format).contains("mm")) {
                    format = (String)format + " '(GMT)'";
                }
            }
            Instant instant = Instant.ofEpochMilli(timeStamp);
            OffsetDateTime odt = OffsetDateTime.ofInstant(instant, zid);
            HttpServletRequest request = WebUtils.getServletRequest();
            try {
                locale = Optional.ofNullable(request.getSession(false).getAttribute("org.zkoss.web.preferred.locale")).map(Locale.class::cast).orElseThrow(Exception::new);
            }
            catch (Exception e) {
                locale = Optional.ofNullable(request.getLocale()).orElse(WebUtils.DEFAULT_LOCALE);
            }
            return odt.format(DateTimeFormatter.ofPattern((String)format, locale));
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        return null;
    }
}

