/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.misc;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gluu.casa.misc.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public final class WebUtils {
    private static Logger LOG = LoggerFactory.getLogger(WebUtils.class);
    public static final String USER_PAGE_URL = "user.zul";
    public static final String ADMIN_PAGE_URL = "admin.zul";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;

    private WebUtils() {
    }

    public static HttpServletRequest getServletRequest() {
        return (HttpServletRequest)Executions.getCurrent().getNativeRequest();
    }

    public static String getRequestHeader(String headerName) {
        return WebUtils.getServletRequest().getHeader(headerName);
    }

    public static void invalidateSession(HttpServletRequest request) {
        Optional.ofNullable(request.getSession(false)).ifPresent(HttpSession::invalidate);
    }

    public static String getRemoteIP() {
        String[] ips;
        String ip = WebUtils.getRequestHeader("X-Forwarded-For");
        ip = ip == null ? WebUtils.getServletRequest().getRemoteAddr() : (Utils.isNotEmpty(ips = ip.split(",\\s*")) ? ips[0] : null);
        return ip;
    }

    public static void execRedirect(String url) {
        WebUtils.execRedirect(url, true);
    }

    public static void execRedirect(String url, boolean voidUI) {
        try {
            Execution exec = Executions.getCurrent();
            HttpServletResponse response = (HttpServletResponse)exec.getNativeResponse();
            LOG.debug("Redirecting to URL={}", (Object)url);
            response.sendRedirect(response.encodeRedirectURL(url));
            if (voidUI) {
                exec.setVoided(voidUI);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getQueryParam(String param) {
        String[] values = Executions.getCurrent().getParameterValues(param);
        return Utils.isEmpty(values) ? null : values[0];
    }

    public static String validateImageUrl(String url) {
        String val = null;
        try {
            val = ImageIO.read(new URL(url)) == null ? null : url;
        }
        catch (Exception e) {
            LOG.warn("Error validating image url '{}'", (Object)url);
        }
        return val;
    }
}

