/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.client.config.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.gluu.casa.client.config.ApiClient;
import org.gluu.casa.client.config.ApiException;
import org.gluu.casa.client.config.ApiResponse;
import org.gluu.casa.client.config.Configuration;
import org.gluu.casa.client.config.Pair;
import org.gluu.casa.client.config.model.ClientSettings;
import org.gluu.casa.client.config.model.OxdConfiguration;
import org.gluu.casa.client.config.model.OxdSettings;
import org.gluu.casa.client.config.model.PluginDescriptor;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void authnMethodsAssignPluginPost(String acr, String plugin) throws ApiException {
        this.authnMethodsAssignPluginPostWithHttpInfo(acr, plugin);
    }

    public ApiResponse<Void> authnMethodsAssignPluginPostWithHttpInfo(String acr, String plugin) throws ApiException {
        Object localVarPostBody = null;
        if (acr == null) {
            throw new ApiException(400, "Missing the required parameter 'acr' when calling authnMethodsAssignPluginPost");
        }
        String localVarPath = "/authn-methods/assign-plugin";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acr != null) {
            localVarFormParams.put("acr", acr);
        }
        if (plugin != null) {
            localVarFormParams.put("plugin", plugin);
        }
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<String> authnMethodsAvailableGet() throws ApiException {
        return this.authnMethodsAvailableGetWithHttpInfo().getData();
    }

    public ApiResponse<List<String>> authnMethodsAvailableGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn-methods/available";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void authnMethodsDisablePost(String acr) throws ApiException {
        this.authnMethodsDisablePostWithHttpInfo(acr);
    }

    public ApiResponse<Void> authnMethodsDisablePostWithHttpInfo(String acr) throws ApiException {
        Object localVarPostBody = null;
        if (acr == null) {
            throw new ApiException(400, "Missing the required parameter 'acr' when calling authnMethodsDisablePost");
        }
        String localVarPath = "/authn-methods/disable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acr != null) {
            localVarFormParams.put("acr", acr);
        }
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<String> authnMethodsEnabledGet() throws ApiException {
        return this.authnMethodsEnabledGetWithHttpInfo().getData();
    }

    public ApiResponse<List<String>> authnMethodsEnabledGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn-methods/enabled";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<String> corsGet() throws ApiException {
        return this.corsGetWithHttpInfo().getData();
    }

    public ApiResponse<List<String>> corsGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cors";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corsPut(List<String> cors) throws ApiException {
        this.corsPutWithHttpInfo(cors);
    }

    public ApiResponse<Void> corsPutWithHttpInfo(List<String> cors) throws ApiException {
        List<String> localVarPostBody = cors;
        if (cors == null) {
            throw new ApiException(400, "Missing the required parameter 'cors' when calling corsPut");
        }
        String localVarPath = "/cors";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public String logLevelGet() throws ApiException {
        return this.logLevelGetWithHttpInfo().getData();
    }

    public ApiResponse<String> logLevelGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/log-level";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void logLevelPost(String level) throws ApiException {
        this.logLevelPostWithHttpInfo(level);
    }

    public ApiResponse<Void> logLevelPostWithHttpInfo(String level) throws ApiException {
        Object localVarPostBody = null;
        if (level == null) {
            throw new ApiException(400, "Missing the required parameter 'level' when calling logLevelPost");
        }
        String localVarPath = "/log-level";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (level != null) {
            localVarFormParams.put("level", level);
        }
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public OxdConfiguration oxdGet() throws ApiException {
        return this.oxdGetWithHttpInfo().getData();
    }

    public ApiResponse<OxdConfiguration> oxdGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oxd";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<OxdConfiguration> localVarReturnType = new GenericType<OxdConfiguration>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClientSettings oxdPut(OxdSettings settings) throws ApiException {
        return this.oxdPutWithHttpInfo(settings).getData();
    }

    public ApiResponse<ClientSettings> oxdPutWithHttpInfo(OxdSettings settings) throws ApiException {
        OxdSettings localVarPostBody = settings;
        if (settings == null) {
            throw new ApiException(400, "Missing the required parameter 'settings' when calling oxdPut");
        }
        String localVarPath = "/oxd";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<ClientSettings> localVarReturnType = new GenericType<ClientSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PluginDescriptor> pluginsAuthnMethodImplAcrGet(String acr) throws ApiException {
        return this.pluginsAuthnMethodImplAcrGetWithHttpInfo(acr).getData();
    }

    public ApiResponse<List<PluginDescriptor>> pluginsAuthnMethodImplAcrGetWithHttpInfo(String acr) throws ApiException {
        Object localVarPostBody = null;
        if (acr == null) {
            throw new ApiException(400, "Missing the required parameter 'acr' when calling pluginsAuthnMethodImplAcrGet");
        }
        String localVarPath = "/plugins/authn-method-impl/{acr}".replaceAll("\\{acr\\}", this.apiClient.escapeString(acr.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<List<PluginDescriptor>> localVarReturnType = new GenericType<List<PluginDescriptor>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PluginDescriptor> pluginsGet() throws ApiException {
        return this.pluginsGetWithHttpInfo().getData();
    }

    public ApiResponse<List<PluginDescriptor>> pluginsGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/plugins";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<List<PluginDescriptor>> localVarReturnType = new GenericType<List<PluginDescriptor>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Integer pluginsScheduleRemovalIdPost(String id) throws ApiException {
        return this.pluginsScheduleRemovalIdPostWithHttpInfo(id).getData();
    }

    public ApiResponse<Integer> pluginsScheduleRemovalIdPostWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling pluginsScheduleRemovalIdPost");
        }
        String localVarPath = "/plugins/schedule-removal/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<Integer> localVarReturnType = new GenericType<Integer>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Boolean pwdResetAvailableGet() throws ApiException {
        return this.pwdResetAvailableGetWithHttpInfo().getData();
    }

    public ApiResponse<Boolean> pwdResetAvailableGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pwd-reset/available";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<Boolean> localVarReturnType = new GenericType<Boolean>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Boolean pwdResetEnabledGet() throws ApiException {
        return this.pwdResetEnabledGetWithHttpInfo().getData();
    }

    public ApiResponse<Boolean> pwdResetEnabledGetWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pwd-reset/enabled";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        GenericType<Boolean> localVarReturnType = new GenericType<Boolean>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void pwdResetTurnOffPost() throws ApiException {
        this.pwdResetTurnOffPostWithHttpInfo();
    }

    public ApiResponse<Void> pwdResetTurnOffPostWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pwd-reset/turn-off";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void pwdResetTurnOnPost() throws ApiException {
        this.pwdResetTurnOnPostWithHttpInfo();
    }

    public ApiResponse<Void> pwdResetTurnOnPostWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pwd-reset/turn-on";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"config_auth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

