/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.util;

public enum SessionStorageType {
    DEFAULT_STORAGE_SERVICE("shibboleth.StorageService"),
    MEMCACHED_STORE_SERVICE("shibboleth.MemcachedStorageService");

    private final String name;

    private SessionStorageType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SessionStorageType from(String name) {
        if (DEFAULT_STORAGE_SERVICE.getName().equals(name)) {
            return DEFAULT_STORAGE_SERVICE;
        }
        if (MEMCACHED_STORE_SERVICE.getName().equals(name)) {
            return MEMCACHED_STORE_SERVICE;
        }
        throw new IllegalArgumentException(name + " not supported!");
    }
}

