/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl.radius;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.OxAuthClient;
import org.gluu.oxtrust.service.ClientService;
import org.gluu.oxtrust.service.ScopeService;
import org.gluu.oxtrust.service.custom.CustomScriptService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.service.radius.GluuRadiusConfigService;
import org.gluu.oxtrust.util.ProductInstallationChecker;
import org.gluu.radius.model.ServerConfiguration;
import org.slf4j.Logger;

@Path(value="/api/v1/radius/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class GluuRadiusConfigWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private GluuRadiusConfigService gluuRadiusConfigService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private CustomScriptService customScriptService;
    @Inject
    private ClientService clientService;

    @GET
    @Operation(summary="Get Radius Server Configuration", description="Get Radius Server Configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ServerConfiguration.class))}, description="Success"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="404", description="Gluu Radius configuration not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getServerConfig() {
        this.log(this.logger, "Get radius server configuration");
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            ServerConfiguration config = this.gluuRadiusConfigService.getServerConfiguration();
            if (config == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)config).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Get Radius Server Configuration", description="Update Radius Server Configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ServerConfiguration.class))}, description="Success"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="404", description="Gluu Radius configuration not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateServerConfiguration(ServerConfiguration newConfig) {
        this.log(this.logger, "Update radius server configuration");
        try {
            List scopes;
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Objects.requireNonNull(newConfig);
            ServerConfiguration oldConfig = this.gluuRadiusConfigService.getServerConfiguration();
            if (oldConfig == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (newConfig.getListenInterface() == null) {
                newConfig.setListenInterface(oldConfig.getListenInterface());
            }
            if (newConfig.getAuthPort() == null) {
                newConfig.setAuthPort(oldConfig.getAuthPort());
            }
            if (newConfig.getAcctPort() == null) {
                newConfig.setAcctPort(oldConfig.getAcctPort());
            }
            if (newConfig.getOpenidBaseUrl() == null) {
                newConfig.setOpenidBaseUrl(oldConfig.getOpenidBaseUrl());
            }
            if (newConfig.getOpenidUsername() == null) {
                newConfig.setOpenidUsername(oldConfig.getOpenidUsername());
                newConfig.setOpenidPassword(oldConfig.getOpenidPassword());
            } else {
                OxAuthClient client = this.clientService.getClientByInum(newConfig.getOpenidUsername());
                if (client == null) {
                    newConfig.setOpenidUsername(oldConfig.getOpenidUsername());
                    newConfig.setOpenidPassword(oldConfig.getOpenidPassword());
                } else {
                    newConfig.setOpenidPassword(client.getEncodedClientSecret());
                }
            }
            String acrValue = newConfig.getAcrValue();
            if (acrValue == null || acrValue != null && !this.isValidAcrValue(acrValue)) {
                newConfig.setAcrValue(oldConfig.getAcrValue());
            }
            if ((scopes = newConfig.getScopes()) == null || scopes != null && scopes.isEmpty()) {
                newConfig.setScopes(oldConfig.getScopes());
            } else {
                List newscopes = scopes;
                for (String scope : scopes) {
                    if (this.isValidScope(scope)) continue;
                    newscopes = oldConfig.getScopes();
                    break;
                }
                newConfig.setScopes(newscopes);
            }
            if (newConfig.getAuthenticationTimeout() == null || newConfig.getAuthenticationTimeout() <= 0) {
                newConfig.setAuthenticationTimeout(oldConfig.getAuthenticationTimeout());
            }
            this.gluuRadiusConfigService.updateServerConfiguration(newConfig);
            return Response.ok((Object)this.gluuRadiusConfigService.getServerConfiguration()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private final boolean isValidAcrValue(String acrValue) {
        ArrayList<CustomScriptType> script_types = new ArrayList<CustomScriptType>();
        script_types.add(CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        List allowed_scripts = this.customScriptService.findCustomScripts(script_types, new String[0]);
        for (CustomScript custom_script : allowed_scripts) {
            if (!custom_script.isEnabled() || !StringUtils.equals((String)custom_script.getName(), (String)acrValue)) continue;
            return true;
        }
        return false;
    }

    private final boolean isValidScope(String scopeDn) throws Exception {
        return this.scopeService.getScopeByDn(scopeDn) != null;
    }
}

