/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl.radius;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.service.radius.GluuRadiusClientService;
import org.gluu.oxtrust.util.ProductInstallationChecker;
import org.gluu.radius.model.RadiusClient;
import org.slf4j.Logger;

@Path(value="/api/v1/radius/clients")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class GluuRadiusClientWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private GluuRadiusClientService gluuRadiusClientService;
    @Inject
    private EncryptionService encryptionService;

    @GET
    @Operation(summary="Get all radius clients", description="Get all radius clients")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=RadiusClient[].class))}, description="Success"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listRadiusClients() {
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            List radiusclients = this.gluuRadiusClientService.getAllClients();
            return Response.ok((Object)radiusclients).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get radius client by inum", description="Get radius client by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=RadiusClient.class))}, description="Success"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="404", description="Radius client not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getRadiusClient(@PathParam(value="inum") @NotNull String inum) {
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            RadiusClient radiusclient = this.gluuRadiusClientService.getRadiusClientByInum(inum);
            if (radiusclient == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)radiusclient).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add new radius client", description="Add new radius client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=RadiusClient.class))}, description="Success"), @ApiResponse(responseCode="400", description="Malformed request. Missing parameter"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response addRadiusClient(RadiusClient client) {
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Objects.requireNonNull(client);
            if (client.getIpAddress() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Client ip not specified").build();
            }
            if (client.getName() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Client name not specified").build();
            }
            if (client.getPriority() == null) {
                client.setPriority(Integer.valueOf(1));
            }
            if (client.getSecret() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Client secret not specified").build();
            }
            String inum = this.gluuRadiusClientService.generateInum();
            client.setInum(inum);
            client.setDn(this.gluuRadiusClientService.getRadiusClientDn(inum));
            String encryptedsecret = this.encryptionService.encrypt(client.getSecret());
            client.setSecret(encryptedsecret);
            this.gluuRadiusClientService.addRadiusClient(client);
            return Response.ok((Object)this.gluuRadiusClientService.getRadiusClientByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update existing radius client", description="Update existing radius client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=RadiusClient.class))}, description="Success"), @ApiResponse(responseCode="400", description="Malformed Request. Missing parameter"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="404", description="Radius client not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateRadiusClient(RadiusClient client) {
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Objects.requireNonNull(client);
            if (client.getInum() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing radius client inum").build();
            }
            String inum = client.getInum();
            RadiusClient existingclient = this.gluuRadiusClientService.getRadiusClientByInum(inum);
            if (existingclient == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (client.getIpAddress() != null) {
                existingclient.setIpAddress(client.getIpAddress());
            }
            if (client.getName() != null) {
                existingclient.setName(client.getName());
            }
            if (client.getPriority() != null) {
                existingclient.setPriority(client.getPriority());
            }
            if (client.getSecret() != null && !StringUtils.equals((String)client.getSecret(), (String)existingclient.getSecret())) {
                String encryptedsecret = this.encryptionService.encrypt(client.getSecret());
                existingclient.setSecret(encryptedsecret);
            }
            this.gluuRadiusClientService.updateRadiusClient(existingclient);
            return Response.ok((Object)this.gluuRadiusClientService.getRadiusClientByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Operation(summary="Delete radius client", description="Deletes a radius client")
    @Path(value="/{inum}")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Success"), @ApiResponse(responseCode="403", description="Gluu Radius is not installed"), @ApiResponse(responseCode="404", description="Radius client not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteRadiusClient(@PathParam(value="inum") @NotNull String inum) {
        try {
            if (!ProductInstallationChecker.isGluuRadiusInstalled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            RadiusClient client = this.gluuRadiusClientService.getRadiusClientByInum(inum);
            if (client == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.gluuRadiusClientService.deleteRadiusClient(client);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

