/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.service.uma.UmaScopeService;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/api/v1/uma/scopes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class UmaScopeWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private UmaScopeService scopeDescriptionService;

    @GET
    @Operation(summary="Get UMA scopes", description="Get uma scopes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listUmaScopes() {
        this.log(this.logger, "Get uma scopes");
        try {
            List umaScopeDescriptions = this.scopeDescriptionService.getAllUmaScopes(100);
            return Response.ok((Object)umaScopeDescriptions).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search UMA scopes", description="Search uma scopes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchUmaScopes(@QueryParam(value="pattern") @NotNull String pattern) {
        this.log(this.logger, "Search uma scope with pattern = " + pattern);
        try {
            List scopes = this.scopeDescriptionService.findUmaScopes(pattern, 100);
            return Response.ok((Object)scopes).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get UMA scope by inum", description="Get a uma scope by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getUmaScopeByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get uma scope " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            Scope scope = this.scopeDescriptionService.getUmaScopeByInum(inum);
            if (scope != null) {
                return Response.ok((Object)scope).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add new UMA scope", description="Add new uma scope")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=Scope.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createUmaScope(Scope umaScopeDescription) {
        this.log(this.logger, "Add new uma scope");
        try {
            Objects.requireNonNull(umaScopeDescription, "Attempt to create null uma scope");
            String inum = umaScopeDescription.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.scopeDescriptionService.generateInumForNewScope();
            }
            umaScopeDescription.setDn(this.scopeDescriptionService.getDnForScope(inum));
            umaScopeDescription.setInum(inum);
            this.scopeDescriptionService.addUmaScope(umaScopeDescription);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.scopeDescriptionService.getUmaScopeByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update UMA scope", description="Update uma scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateUmaScope(Scope umaScopeDescription) {
        String inum = umaScopeDescription.getInum();
        this.log(this.logger, "Update uma scope " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            Objects.requireNonNull(umaScopeDescription, "Attempt to update null uma scope");
            Scope existingScope = this.scopeDescriptionService.getUmaScopeByInum(inum);
            if (existingScope != null) {
                umaScopeDescription.setDn(this.scopeDescriptionService.getDnForScope(inum));
                this.scopeDescriptionService.updateUmaScope(umaScopeDescription);
                return Response.ok((Object)this.scopeDescriptionService.getUmaScopeByInum(inum)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete UMA scope", description="Delete a uma scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteUmaScope(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Delete a uma scope having inum " + inum);
        try {
            Scope existingScope = this.scopeDescriptionService.getUmaScopeByInum(inum);
            if (existingScope != null) {
                this.scopeDescriptionService.removeUmaScope(existingScope);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

