/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.OxAuthClient;
import org.gluu.oxtrust.service.ClientService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.service.uma.ResourceSetService;
import org.gluu.oxtrust.service.uma.UmaScopeService;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/api/v1/uma/resources")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class UmaResourceWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ResourceSetService umaResourcesService;
    @Inject
    private UmaScopeService scopeDescriptionService;
    @Inject
    private ClientService clientService;

    @GET
    @Operation(summary="Get UMA resources", description="Get uma resources")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listUmaResources() {
        try {
            this.log(this.logger, "Get uma resources");
            return Response.ok((Object)this.umaResourcesService.getAllResources(1000)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search UMA resources", description="Search uma resources")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchUmaResources(@QueryParam(value="pattern") @NotNull String pattern, @QueryParam(value="size") @NotNull int size) {
        try {
            this.log(this.logger, "Search uma resources with pattern = " + pattern + " and size = " + size);
            List ressources = this.umaResourcesService.findResources(pattern, size);
            return Response.ok((Object)ressources).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get UMA resource by id", description="Get a uma resource by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getUmaResourceById(@PathParam(value="id") @NotNull String id) {
        try {
            this.log(this.logger, "Get uma resource by id " + id);
            Objects.requireNonNull(id, "id should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            if (resources != null && !resources.isEmpty()) {
                return Response.ok(resources.get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{id}/clients")
    @Operation(summary="Get clients of UMA resources", description="Get clients of uma resource")
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getUmaResourceClients(@PathParam(value="id") @NotNull String id) {
        try {
            this.log(this.logger, "Get clients of uma resource having id " + id);
            Objects.requireNonNull(id, "id should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            if (resources != null && !resources.isEmpty()) {
                UmaResource resource = (UmaResource)resources.get(0);
                List clientsDn = resource.getClients();
                ArrayList<OxAuthClient> clients = new ArrayList<OxAuthClient>();
                if (clientsDn != null) {
                    for (String clientDn : clientsDn) {
                        clients.add(this.clientService.getClientByDn(clientDn));
                    }
                }
                return Response.ok(clients).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{id}/scopes")
    @Operation(summary="Get UMA resource scopes", description="Get scopes of uma resource")
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getUmaResourceScopes(@PathParam(value="id") @NotNull String id) {
        try {
            this.log(this.logger, "Get scopes of uma resource having id " + id);
            Objects.requireNonNull(id, "id should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            if (resources != null && !resources.isEmpty()) {
                UmaResource resource = (UmaResource)resources.get(0);
                List scopesDn = resource.getScopes();
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                if (scopesDn != null) {
                    for (String scopeDn : scopesDn) {
                        scopes.add(this.scopeDescriptionService.getUmaScopeByDn(scopeDn));
                    }
                }
                return Response.ok(scopes).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add UMA resource client", description="add client to uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{id}/clients/{inum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response addClientToUmaResource(@PathParam(value="id") @NotNull String id, @PathParam(value="inum") @NotNull String clientInum) {
        try {
            this.log(this.logger, "Add client " + clientInum + " to uma resource " + id);
            Objects.requireNonNull(id, "Uma id should not be null");
            Objects.requireNonNull(clientInum, "Client inum should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            OxAuthClient client = this.clientService.getClientByInum(clientInum);
            if (resources != null && !resources.isEmpty() && client != null) {
                UmaResource umaResource = (UmaResource)resources.get(0);
                ArrayList<String> clientsDn = new ArrayList<String>();
                if (umaResource.getClients() != null) {
                    clientsDn.addAll(umaResource.getClients());
                }
                clientsDn.add(this.clientService.getDnForClient(clientInum));
                umaResource.setClients(clientsDn);
                this.umaResourcesService.updateResource(umaResource);
                return Response.status((Response.Status)Response.Status.CREATED).entity(this.umaResourcesService.findResourcesById(id).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Operation(summary="Remove UMA resource client", description="Remove client from uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{id}/clients/{inum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response removeClientToUmaResource(@PathParam(value="id") @NotNull String id, @PathParam(value="inum") @NotNull String clientInum) {
        try {
            this.log(this.logger, "Remove client " + clientInum + " from uma resource " + id);
            Objects.requireNonNull(id, "Uma id should not be null");
            Objects.requireNonNull(clientInum, "Client inum should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            OxAuthClient client = this.clientService.getClientByInum(clientInum);
            if (resources != null && !resources.isEmpty() && client != null) {
                UmaResource umaResource = (UmaResource)resources.get(0);
                ArrayList clientsDn = new ArrayList();
                if (umaResource.getClients() != null) {
                    clientsDn.addAll(umaResource.getClients());
                }
                clientsDn.remove(this.clientService.getDnForClient(clientInum));
                umaResource.setClients(clientsDn);
                this.umaResourcesService.updateResource(umaResource);
                return Response.ok(this.umaResourcesService.findResourcesById(id).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add UMA resource scope", description="add scope to uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{id}/scopes/{inum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response addScopeToUmaResource(@PathParam(value="id") @NotNull String id, @PathParam(value="inum") @NotNull String scopeInum) {
        this.log(this.logger, "Add scope " + scopeInum + " to uma resource " + id);
        try {
            Objects.requireNonNull(id, "Uma id should not be null");
            Objects.requireNonNull(scopeInum, "scope inum should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            Scope umaScope = this.scopeDescriptionService.getUmaScopeByInum(scopeInum);
            if (resources != null && !resources.isEmpty() && umaScope != null) {
                UmaResource umaResource = (UmaResource)resources.get(0);
                ArrayList<String> scopesDn = new ArrayList<String>();
                if (umaResource.getScopes() != null) {
                    scopesDn.addAll(umaResource.getScopes());
                }
                scopesDn.add(this.scopeDescriptionService.getDnForScope(scopeInum));
                umaResource.setScopes(scopesDn);
                this.umaResourcesService.updateResource(umaResource);
                return Response.ok(this.umaResourcesService.findResourcesById(id).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Operation(summary="Remove UMA resource scope", description="remove a scope from uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{id}/scopes/{inum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response removeScopeToUmaResource(@PathParam(value="id") @NotNull String id, @PathParam(value="inum") @NotNull String scopeInum) {
        try {
            this.log(this.logger, "Remove scope " + scopeInum + " from uma resource " + id);
            Objects.requireNonNull(id, "Uma id should not be null");
            Objects.requireNonNull(scopeInum, "scope inum should not be null");
            List resources = this.umaResourcesService.findResourcesById(id);
            Scope umaScope = this.scopeDescriptionService.getUmaScopeByInum(scopeInum);
            if (resources != null && !resources.isEmpty() && umaScope != null) {
                UmaResource umaResource = (UmaResource)resources.get(0);
                ArrayList scopesDn = new ArrayList();
                if (umaResource.getScopes() != null) {
                    scopesDn.addAll(umaResource.getScopes());
                }
                scopesDn.remove(this.scopeDescriptionService.getDnForScope(scopeInum));
                umaResource.setScopes(scopesDn);
                this.umaResourcesService.updateResource(umaResource);
                return Response.ok(this.umaResourcesService.findResourcesById(id).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add new UMA resource", description="Add new uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createUmaResource(UmaResource umaResource) {
        try {
            String inum;
            this.log(this.logger, "Add new uma resource");
            Objects.requireNonNull(umaResource, "Attempt to create null resource");
            if (umaResource.getId() == null) {
                umaResource.setId(UUID.randomUUID().toString());
            }
            if (StringHelper.isEmpty((String)(inum = umaResource.getInum()))) {
                inum = this.umaResourcesService.generateInumForNewResource();
            }
            umaResource.setDn(this.umaResourcesService.getDnForResource(umaResource.getId()));
            umaResource.setInum(inum);
            this.umaResourcesService.addResource(umaResource);
            List umaResources = this.umaResourcesService.findResourcesById(umaResource.getId());
            return Response.ok(umaResources.get(0)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update UMA resource", description="Update uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UmaResource.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateUmaResource(UmaResource umaResource) {
        try {
            String id = umaResource.getId();
            this.log(this.logger, "Update uma resource having id " + id);
            Objects.requireNonNull(id, " id should not be null");
            Objects.requireNonNull(umaResource, "Attempt to update null uma resource");
            List existingResources = this.umaResourcesService.findResourcesById(id);
            if (existingResources != null && !existingResources.isEmpty()) {
                umaResource.setDn(this.umaResourcesService.getDnForResource(id));
                this.umaResourcesService.updateResource(umaResource);
                return Response.ok(this.umaResourcesService.findResourcesById(id).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete UMA resource", description="Delete a uma resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteUmaResource(@PathParam(value="id") @NotNull String id) {
        try {
            this.log(this.logger, "Delete uma resource with id = " + id);
            List resources = this.umaResourcesService.findResourcesById(id);
            if (resources != null && !resources.isEmpty()) {
                this.umaResourcesService.removeResource((UmaResource)resources.get(0));
                this.log(this.logger, "Delete a uma resource having id " + id + " done");
                return Response.ok().build();
            }
            this.log(this.logger, "No uma scope found with " + id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

