/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.model.SmtpConfiguration;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.service.MailService;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/smtp")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class SmtpConfigurationWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private MailService mailService;
    @Inject
    private EncryptionService encryptionService;

    @GET
    @Operation(summary="Get smtp configuration", description="Get smtp configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SmtpConfiguration.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getSmtpServerConfiguration() {
        try {
            SmtpConfiguration smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
            if (smtpConfiguration != null) {
                return Response.ok((Object)smtpConfiguration).build();
            }
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update smtp configuration", description="Update smtp configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SmtpConfiguration.class))}, description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateSmtpConfiguration(SmtpConfiguration smtpConfiguration) {
        try {
            Preconditions.checkNotNull((Object)smtpConfiguration, (Object)"Attempt to update null smtpConfiguration");
            this.configurationService.encryptedSmtpPassword(smtpConfiguration);
            GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
            configurationUpdate.setSmtpConfiguration(smtpConfiguration);
            this.configurationService.updateConfiguration(configurationUpdate);
            return Response.ok((Object)this.configurationService.getConfiguration().getSmtpConfiguration()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/test")
    @Operation(summary="Test smtp configuration", description="Test smtp configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SmtpConfiguration.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response testSmtpConfiguration() {
        try {
            SmtpConfiguration smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
            String password = this.encryptionService.decrypt(smtpConfiguration.getPassword());
            smtpConfiguration.setPasswordDecrypted(password);
            boolean result = this.mailService.sendMail(smtpConfiguration, smtpConfiguration.getFromEmailAddress(), smtpConfiguration.getFromName(), smtpConfiguration.getFromEmailAddress(), null, "SMTP Configuration verification", "Mail to test smtp configuration", "Mail to test smtp configuration");
            return Response.ok((Object)(result ? 1 : 0)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

