/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.GluuServerStatus;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.model.GluuOxTrustStat;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/status")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class ServerStatusWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;

    @GET
    @Operation(summary="Get server status", description="Get server status")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuServerStatus.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getServerStatus() {
        this.log("Get server status");
        try {
            return Response.ok((Object)this.convert(this.configurationService.getOxtrustStat(), this.configurationService.getConfiguration())).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private void log(String message) {
        this.logger.debug("################# Request: " + message);
    }

    private GluuServerStatus convert(GluuOxTrustStat configuration, GluuConfiguration conf) {
        GluuServerStatus status = new GluuServerStatus();
        status.setHostname(conf.getHostname());
        status.setIpAddress(configuration.getIpAddress());
        status.setUptime(configuration.getSystemUptime());
        status.setPersonCount(configuration.getPersonCount());
        status.setGroupCount(configuration.getGroupCount());
        status.setLastUpdate(conf.getLastUpdate());
        status.setFreeMemory(configuration.getFreeMemory());
        status.setFreeDiskSpace(configuration.getFreeDiskSpace());
        status.setPollingInterval(conf.getPollingInterval());
        return status;
    }
}

