/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.OxAuthSectorIdentifier;
import org.gluu.oxtrust.service.SectorIdentifierService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/sectoridentifiers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class SectorIdentifierWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    @GET
    @Operation(summary="Get all sector identifiers", description="Get all sectors identifiers")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthSectorIdentifier[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAllSectorIdentifiers() {
        this.log("Get all sectors identifiers ");
        try {
            return Response.ok((Object)this.sectorIdentifierService.getAllSectorIdentifiers()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/sector/{id}")
    @Operation(summary="Get sector identifier", description="Get a sector identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthSectorIdentifier.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getSectorIdentifierById(@PathParam(value="id") @NotNull String id) {
        this.log("Get sector identifier having id: " + id);
        try {
            Objects.requireNonNull(id);
            OxAuthSectorIdentifier sectorIdentifier = this.sectorIdentifierService.getSectorIdentifierById(id);
            if (sectorIdentifier != null) {
                return Response.ok((Object)sectorIdentifier).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search sector identifiers", description="Search sectors identifiers")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthSectorIdentifier[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchSectorIdentifier(@QueryParam(value="pattern") String pattern, @DefaultValue(value="10") @QueryParam(value="size") int size) {
        this.log("Search sector with pattern= " + pattern + "and size: " + size);
        try {
            List sectorIdentifiers = this.sectorIdentifierService.searchSectorIdentifiers(pattern, size);
            return Response.ok((Object)sectorIdentifiers).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add sector identifier", description="Add a sector identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthSectorIdentifier.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createSectorIdentifier(OxAuthSectorIdentifier identifier) {
        this.log("Create a sector identifier");
        try {
            Objects.requireNonNull(identifier);
            String oxId = identifier.getId();
            if (oxId == null) {
                oxId = UUID.randomUUID().toString();
            }
            identifier.setBaseDn(this.sectorIdentifierService.getDnForSectorIdentifier(oxId));
            this.sectorIdentifierService.addSectorIdentifier(identifier);
            return Response.ok((Object)this.sectorIdentifierService.getSectorIdentifierById(oxId)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update sector identifier", description="Update sector identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthSectorIdentifier.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateSectorIdentifier(OxAuthSectorIdentifier identifier) {
        Objects.requireNonNull(identifier);
        String id = identifier.getId();
        this.log(" Update sector identifier " + id);
        try {
            OxAuthSectorIdentifier existingIdentifier;
            if (id == null) {
                id = UUID.randomUUID().toString();
            }
            if ((existingIdentifier = this.sectorIdentifierService.getSectorIdentifierById(id)) != null) {
                identifier.setId(existingIdentifier.getId());
                this.sectorIdentifierService.updateSectorIdentifier(identifier);
                return Response.ok((Object)this.sectorIdentifierService.getSectorIdentifierById(id)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete sector identifier", description="Delete a sector identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteSectorIdentifier(@PathParam(value="inum") @NotNull String id) {
        this.log("Delete sector identifier with id: " + id);
        try {
            OxAuthSectorIdentifier sectorIdentifier = this.sectorIdentifierService.getSectorIdentifierById(id);
            if (sectorIdentifier != null) {
                this.sectorIdentifierService.removeSectorIdentifier(sectorIdentifier);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private void log(String message) {
        this.logger.debug("################# Request: " + message);
    }
}

