/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.model.GluuAttribute;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.AttributeService;
import org.gluu.oxtrust.service.ScopeService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/api/v1/scopes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class ScopeWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;

    @GET
    @Operation(summary="Get all scopes", description="Get all scopes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAllScopes() {
        this.log(this.logger, "List openid connect scopes ");
        try {
            return Response.ok((Object)this.scopeService.searchScopes(null, 100)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get openid scope", description="Get a specific openid connect scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getScopeByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get openid connect scope by " + inum);
        try {
            Scope scope = this.scopeService.getScopeByInum(inum);
            if (scope != null) {
                return Response.ok((Object)scope).build();
            }
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search openid connect scopes", description="Search openid connect scopes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchScope(@QueryParam(value="pattern") String pattern, @DefaultValue(value="10") @QueryParam(value="size") int size) {
        this.log(this.logger, "Search openid connect scopes with pattern= " + pattern);
        try {
            List scopes = this.scopeService.searchScopes(pattern, size);
            return Response.ok((Object)scopes).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add openid connect scope", description="Add an openidconnect scope")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=Scope.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createScope(Scope scope) {
        this.log(this.logger, "Create scope");
        try {
            Objects.requireNonNull(scope, "Attempt to create null scope");
            String inum = scope.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.scopeService.generateInumForNewScope();
            }
            scope.setInum(inum);
            scope.setDn(this.scopeService.getDnForScope(inum));
            this.scopeService.addScope(scope);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.scopeService.getScopeByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update openid connect scope", description="Update openidconect scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateScope(Scope scope) {
        String inum = scope.getInum();
        this.log(this.logger, "Update scope " + inum);
        try {
            Objects.requireNonNull(scope, "Attempt to update scope null value");
            Objects.requireNonNull(inum);
            Scope existingScope = this.scopeService.getScopeByInum(inum);
            if (existingScope != null) {
                scope.setInum(existingScope.getInum());
                this.scopeService.updateScope(scope);
                return Response.ok((Object)this.scopeService.getScopeByInum(inum)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}/claims")
    @Operation(summary="Get scope claims", description="List all claims of a scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response getScopeClaims(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "List all claims of scope ==> " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            Scope oxAuthScope = this.scopeService.getScopeByInum(inum);
            ArrayList claimsDn = new ArrayList();
            ArrayList<GluuAttribute> attributes = new ArrayList<GluuAttribute>();
            if (oxAuthScope != null) {
                claimsDn.addAll(oxAuthScope.getOxAuthClaims());
                for (String claimDn : claimsDn) {
                    attributes.add(this.attributeService.getAttributeByDn(claimDn));
                }
                return Response.ok(attributes).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete openid connect scope", description="Delete an openidconnect scope")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteScope(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Delete openidconnect scope " + inum);
        try {
            Scope scope = this.scopeService.getScopeByInum(inum);
            if (scope != null) {
                this.scopeService.removeScope(scope);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

