/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.GluuPersonApi;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.oxtrust.service.PersonService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/api/v1/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class PeopleWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private PersonService personService;

    @GET
    @Operation(summary="Get people", description="Get people")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuPersonApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listPeople() {
        try {
            this.log(this.logger, "Get people");
            List<GluuPersonApi> groups = this.convert(this.personService.findAllPersons(null));
            return Response.ok(groups).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search person", description="Search person")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuPersonApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchPeople(@QueryParam(value="pattern") @NotNull String pattern) {
        try {
            this.log(this.logger, "Search person with pattern= " + pattern);
            List groups = this.personService.searchPersons(pattern);
            return Response.ok(this.convert(groups)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get person by inum", description="Get a person by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuPersonApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getPersonByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get person " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            GluuCustomPerson person = this.personService.getPersonByInum(inum);
            if (person != null) {
                return Response.ok((Object)this.convert(Arrays.asList(person)).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add person", description="Add a person")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=GluuPersonApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createPerson(GluuPersonApi person) {
        this.log(this.logger, "Adding person " + person.getDisplayName());
        try {
            Objects.requireNonNull(person, "Attempt to create null person");
            GluuCustomPerson gluuPerson = this.copyAttributes(person);
            String inum = person.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.personService.generateInumForNewPerson();
            }
            gluuPerson.setDn(this.personService.getDnForPerson(inum));
            gluuPerson.setInum(inum);
            this.personService.addPerson(gluuPerson);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.convert(Arrays.asList(this.personService.getPersonByInum(inum))).get(0)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update person", description="Update a person")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuPersonApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updatePerson(GluuPersonApi person) {
        String inum = person.getInum();
        this.log(this.logger, "Update group " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            Objects.requireNonNull(person, "Attempt to update null person");
            GluuCustomPerson existingPerson = this.personService.getPersonByInum(inum);
            if (existingPerson != null) {
                person.setInum(existingPerson.getInum());
                person.setPassword(existingPerson.getUserPassword());
                GluuCustomPerson personToUpdate = this.updateValues(existingPerson, person);
                personToUpdate.setDn(this.personService.getDnForPerson(inum));
                this.personService.updatePerson(personToUpdate);
                return Response.ok((Object)this.convert(Arrays.asList(this.personService.getPersonByInum(inum))).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete person", description="Delete a person")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deletePerson(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Delete person having inum " + inum);
        try {
            GluuCustomPerson existingPerson = this.personService.getPersonByInum(inum);
            if (existingPerson != null) {
                this.personService.removePerson(existingPerson);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<GluuPersonApi> convert(List<GluuCustomPerson> persons) {
        ArrayList<GluuPersonApi> result = new ArrayList<GluuPersonApi>();
        for (GluuCustomPerson p : persons) {
            result.add(new GluuPersonApi(p));
        }
        return result;
    }

    private GluuCustomPerson copyAttributes(GluuPersonApi person) {
        GluuCustomPerson gluuCustomPerson = new GluuCustomPerson();
        gluuCustomPerson.setUid(person.getUserName());
        gluuCustomPerson.setInum(person.getInum());
        gluuCustomPerson.setGivenName(person.getGivenName());
        gluuCustomPerson.setMail(person.getEmail());
        gluuCustomPerson.setDisplayName(person.getDisplayName());
        gluuCustomPerson.setSurname(person.getSurName());
        gluuCustomPerson.setCreationDate(person.getCreationDate());
        gluuCustomPerson.setStatus(person.getStatus());
        gluuCustomPerson.setUserPassword(person.getPassword());
        gluuCustomPerson.setAttribute("oxTrustActive", "true");
        return gluuCustomPerson;
    }

    private GluuCustomPerson updateValues(GluuCustomPerson gluuCustomPerson, GluuPersonApi person) {
        gluuCustomPerson.setUid(person.getUserName());
        gluuCustomPerson.setDisplayName(person.getDisplayName());
        gluuCustomPerson.setCreationDate(person.getCreationDate());
        gluuCustomPerson.setMail(person.getEmail());
        gluuCustomPerson.setGivenName(person.getGivenName());
        gluuCustomPerson.setStatus(person.getStatus());
        gluuCustomPerson.setSurname(person.getSurName());
        gluuCustomPerson.setUserPassword(person.getPassword());
        gluuCustomPerson.setAttribute("oxTrustActive", "true");
        return gluuCustomPerson;
    }
}

