/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.config.oxtrust.LdapOxPassportConfiguration;
import org.gluu.model.passport.PassportConfiguration;
import org.gluu.model.passport.Provider;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.PassportService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/passport/providers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class PassportProviderWebResource
extends BaseWebResource {
    private LdapOxPassportConfiguration ldapOxPassportConfiguration;
    private PassportConfiguration passportConfiguration;
    @Inject
    private Logger logger;
    @Inject
    private PassportService passportService;

    @GET
    @Operation(summary="List passport providers", description="List passport providers")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Provider[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listProviders() {
        this.log(this.logger, "List passport providers");
        try {
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            ArrayList providers = new ArrayList();
            providers.addAll(this.passportConfiguration.getProviders());
            return Response.ok(providers).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get passport provider by id", description="Get passport provider by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Provider.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getProviderById(@PathParam(value="id") @NotNull String id) {
        this.log(this.logger, "Get group having group" + id);
        id = id.equalsIgnoreCase("") ? null : id;
        try {
            Objects.requireNonNull(id, "inum should not be null");
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            ArrayList<Provider> providers = new ArrayList<Provider>();
            providers.addAll(this.passportConfiguration.getProviders());
            Provider existingProvider = this.getExistingProvider(providers, id);
            if (existingProvider != null) {
                return Response.ok((Object)existingProvider).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add passport provider", description="Add passport provider")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Provider.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createPassportProvider(Provider provider) {
        this.log(this.logger, "Add passport provider " + provider.getDisplayName());
        try {
            Objects.requireNonNull(provider, "Attempt to create null provider");
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            ArrayList<Provider> providers = new ArrayList<Provider>();
            providers.addAll(this.passportConfiguration.getProviders());
            if (provider.getId() == null) {
                String computedId = provider.getDisplayName().toLowerCase().replaceAll("[^\\w-]", "");
                computedId = computedId.concat(UUID.randomUUID().toString().substring(0, 4));
                provider.setId(computedId);
            }
            providers.add(provider);
            this.passportConfiguration.setProviders(providers);
            this.ldapOxPassportConfiguration.setPassportConfiguration(this.passportConfiguration);
            this.passportService.updateLdapOxPassportConfiguration(this.ldapOxPassportConfiguration);
            return Response.ok((Object)provider).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update passport provider", description="Update passport provider")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Provider.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updatePassportProvider(Provider provider) {
        String id = provider.getId();
        id = id.equalsIgnoreCase("") ? null : id;
        this.log(this.logger, "Update passport provider " + id);
        try {
            Objects.requireNonNull(id, "id should not be null");
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            ArrayList<Provider> providers = new ArrayList<Provider>();
            providers.addAll(this.passportConfiguration.getProviders());
            Provider existingProvider = this.getExistingProvider(providers, id);
            if (existingProvider != null) {
                providers.remove(existingProvider);
                providers.add(provider);
                this.passportConfiguration.setProviders(providers);
                this.ldapOxPassportConfiguration.setPassportConfiguration(this.passportConfiguration);
                this.passportService.updateLdapOxPassportConfiguration(this.ldapOxPassportConfiguration);
                return Response.ok((Object)provider).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Provider getExistingProvider(List<Provider> providers, String id) {
        Provider result = null;
        for (Provider provider : providers) {
            if (!provider.getId().equalsIgnoreCase(id)) continue;
            result = provider;
            break;
        }
        return result;
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete passport provider", description="Delete a passport provider")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteProvider(@PathParam(value="id") @NotNull String id) {
        this.log(this.logger, "Delete passport provider having id " + id);
        try {
            Objects.requireNonNull(id, "id should not be null");
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            ArrayList providers = new ArrayList();
            providers.addAll(this.passportConfiguration.getProviders());
            Provider found = null;
            for (Provider provider : providers) {
                if (!id.equalsIgnoreCase(provider.getId())) continue;
                found = provider;
                break;
            }
            if (found != null) {
                providers.remove(found);
                this.passportConfiguration.setProviders(providers);
                this.ldapOxPassportConfiguration.setPassportConfiguration(this.passportConfiguration);
                this.passportService.updateLdapOxPassportConfiguration(this.ldapOxPassportConfiguration);
                return Response.ok().build();
            }
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteAllProviders() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

