/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.config.oxtrust.LdapOxPassportConfiguration;
import org.gluu.model.passport.PassportConfiguration;
import org.gluu.model.passport.config.Configuration;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.PassportService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/passport/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class PassportBasicConfigWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private PassportService passportService;
    private LdapOxPassportConfiguration ldapOxPassportConfiguration;
    private PassportConfiguration passportConfiguration;

    @GET
    @Operation(summary="Get passport basic configuration", description="Get passport basic configuration")
    @ProtectedApi(scopes={"oxtrust-api-read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=PassportConfiguration[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    public Response getPassportBasicConfig() {
        this.log(this.logger, "Get passport basic configuration");
        try {
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            return Response.ok((Object)this.passportConfiguration.getConf()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update passport basic configuration", description="Update passport basic configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=PassportConfiguration[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updatePassportBasicConfig(Configuration configuration) {
        this.log(this.logger, "Update passport basic configuration");
        try {
            Objects.requireNonNull(configuration, "config should not be null");
            this.ldapOxPassportConfiguration = this.passportService.loadConfigurationFromLdap();
            this.passportConfiguration = this.ldapOxPassportConfiguration.getPassportConfiguration();
            this.passportConfiguration.setConf(configuration);
            this.ldapOxPassportConfiguration.setPassportConfiguration(this.passportConfiguration);
            this.passportService.updateLdapOxPassportConfiguration(this.ldapOxPassportConfiguration);
            return Response.ok((Object)this.passportService.loadConfigurationFromLdap().getPassportConfiguration().getConf()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

