/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.OxtrustSetting;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class OxtrustSettingWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;

    @GET
    @Operation(summary="Get oxtrust settings", description="Get oxtrust settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxtrustSetting.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getOxtrustSettings() {
        try {
            this.log(this.logger, "Processing oxtrust settings retrieval request");
            GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
            OxtrustSetting setting = new OxtrustSetting();
            setting.setAllowPasswordReset(String.valueOf(configurationUpdate.isPasswordResetAllowed()));
            setting.setAllowProfileManagement(String.valueOf(configurationUpdate.isProfileManagment()));
            setting.setEnablePassport(String.valueOf(configurationUpdate.isPassportEnabled()));
            setting.setEnableScim(String.valueOf(configurationUpdate.isScimEnabled()));
            return Response.ok((Object)setting).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update oxtrust settings", description="Update oxtrust settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxtrustSetting.class))}, description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateOxtrustSetting(OxtrustSetting oxtrustSetting) {
        try {
            this.log(this.logger, "Processing oxtrust settings update request");
            Preconditions.checkNotNull((Object)oxtrustSetting, (Object)"Attempt to update null oxtrust settings");
            GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
            configurationUpdate.setScimEnabled(Boolean.valueOf(oxtrustSetting.getEnableScim()).booleanValue());
            configurationUpdate.setPassportEnabled(Boolean.valueOf(oxtrustSetting.getEnablePassport()).booleanValue());
            configurationUpdate.setPasswordResetAllowed(Boolean.valueOf(oxtrustSetting.getAllowPasswordReset()).booleanValue());
            configurationUpdate.setProfileManagment(Boolean.valueOf(oxtrustSetting.getAllowProfileManagement()).booleanValue());
            this.configurationService.updateConfiguration(configurationUpdate);
            return Response.ok((Object)"success").build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

