/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.OxTrustJsonSetting;
import org.gluu.oxtrust.service.JsonConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/oxtrust/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class OxTrustJsonSettingWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private JsonConfigurationService jsonConfigurationService;
    private AppConfiguration oxTrustappConfiguration;

    @GET
    @Operation(summary="Get json oxtrust settings", description="Get json oxtrust settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxTrustJsonSetting.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getOxtrustJsonSettings() {
        try {
            this.log(this.logger, "Processing oxtrust json settings retrival");
            this.oxTrustappConfiguration = this.jsonConfigurationService.getOxTrustappConfiguration();
            OxTrustJsonSetting setting = new OxTrustJsonSetting();
            setting.setOrgName(this.oxTrustappConfiguration.getOrganizationName());
            setting.setSupportEmail(this.oxTrustappConfiguration.getOrgSupportEmail());
            setting.setAuthenticationRecaptchaEnabled(this.oxTrustappConfiguration.isAuthenticationRecaptchaEnabled());
            setting.setCleanServiceInterval(this.oxTrustappConfiguration.getCleanServiceInterval());
            setting.setEnforceEmailUniqueness(this.oxTrustappConfiguration.getEnforceEmailUniqueness());
            setting.setPasswordResetRequestExpirationTime(this.oxTrustappConfiguration.getPasswordResetRequestExpirationTime());
            setting.setLoggingLevel(this.oxTrustappConfiguration.getLoggingLevel());
            setting.setScimTestMode(this.oxTrustappConfiguration.isScimTestMode());
            return Response.ok((Object)setting).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update json oxtrust settings", description="Update json oxtrust settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxTrustJsonSetting.class))}, description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateOxtrustJsonSetting(OxTrustJsonSetting oxtrustJsonSetting) {
        try {
            this.log(this.logger, "Processing oxtrust json update request");
            Preconditions.checkNotNull((Object)oxtrustJsonSetting, (Object)"Attempt to update null oxtrust json settings");
            this.oxTrustappConfiguration = this.jsonConfigurationService.getOxTrustappConfiguration();
            this.oxTrustappConfiguration.setOrganizationName(oxtrustJsonSetting.getOrgName());
            this.oxTrustappConfiguration.setOrgSupportEmail(oxtrustJsonSetting.getSupportEmail());
            this.oxTrustappConfiguration.setScimTestMode(oxtrustJsonSetting.isScimTestMode());
            this.oxTrustappConfiguration.setPasswordResetRequestExpirationTime(oxtrustJsonSetting.getPasswordResetRequestExpirationTime());
            this.oxTrustappConfiguration.setEnforceEmailUniqueness(Boolean.valueOf(oxtrustJsonSetting.isEnforceEmailUniqueness()));
            this.oxTrustappConfiguration.setCleanServiceInterval(oxtrustJsonSetting.getCleanServiceInterval());
            this.oxTrustappConfiguration.setLoggingLevel(oxtrustJsonSetting.getLoggingLevel());
            this.oxTrustappConfiguration.setAuthenticationRecaptchaEnabled(oxtrustJsonSetting.isAuthenticationRecaptchaEnabled());
            this.jsonConfigurationService.saveOxTrustappConfiguration(this.oxTrustappConfiguration);
            return Response.ok((Object)"success").build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

