/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.OxAuthJsonConfiguration;
import org.gluu.oxtrust.service.JsonConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/oxauth/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class OxAuthJsonSettingWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private JsonConfigurationService jsonConfigurationService;
    private String oxAuthDynamicConfigJson;

    @GET
    @Operation(summary="Get json oxauth settings", description="Gets oxAuth configuration in JSON format", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthJsonConfiguration.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getOxAuthJsonSettings() {
        try {
            this.log(this.logger, "Processing oxauth json settings retrieval request");
            this.oxAuthDynamicConfigJson = this.jsonConfigurationService.getOxAuthDynamicConfigJson();
            OxAuthJsonConfiguration configuration = (OxAuthJsonConfiguration)new ObjectMapper().readValue(this.oxAuthDynamicConfigJson, OxAuthJsonConfiguration.class);
            return Response.ok((Object)configuration).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update json oxauth settings", description="Updates the oxAuth JSON configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthJsonConfiguration.class))}, description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateOxauthJsonSetting(OxAuthJsonConfiguration oxAuthJsonSetting) {
        try {
            this.log(this.logger, "Processing oxauth json settings update request");
            Preconditions.checkNotNull((Object)oxAuthJsonSetting, (Object)"Attempt to update null oxauth json settings");
            String value = new ObjectMapper().writeValueAsString((Object)oxAuthJsonSetting);
            this.jsonConfigurationService.saveOxAuthDynamicConfigJson(value);
            return Response.ok((Object)"success").build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

