/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.api.impl.ExistingLdapConfigurationValidator;
import org.gluu.oxtrust.api.server.model.ConnectionStatusDTO;
import org.gluu.oxtrust.api.server.util.LdapConfigurationDtoAssembly;
import org.gluu.oxtrust.api.server.util.LdapConfigurationDuplicatedException;
import org.gluu.oxtrust.service.LdapConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.util.ConnectionStatus;
import org.gluu.oxtrust.util.LdapConfigurationDTO;
import org.gluu.oxtrust.util.LdapConnectionData;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/ldap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class LDAPAuthenticationWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private LdapConfigurationService ldapConfigurationService;
    @Inject
    private ConnectionStatus connectionStatus;
    private ExistingLdapConfigurationValidator existingLdapConfigurationValidator = new ExistingLdapConfigurationValidator();
    private LdapConfigurationDtoAssembly ldapConfigurationDtoAssembly = new LdapConfigurationDtoAssembly();

    @GET
    @Operation(summary="Get existing configuration", description="Get the existing configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=org.gluu.oxtrust.api.server.model.LdapConfigurationDTO[].class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getLdapConfiguration() {
        this.log(this.logger, "Get the existing configuration");
        try {
            ImmutableList result = FluentIterable.from((Iterable)this.ldapConfigurationService.findLdapConfigurations()).transform(this.ldapConfigurationDtoAssembly.toDtoAsFunction()).toList();
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update existing configuration", description="Update an existing configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=org.gluu.oxtrust.api.server.model.LdapConfigurationDTO.class))}, description="Success"), @ApiResponse(responseCode="404", description="Not found")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateLdapConfiguration(@Valid org.gluu.oxtrust.api.server.model.LdapConfigurationDTO ldapConfiguration) {
        this.log(this.logger, "Update an existing configuration");
        try {
            GluuLdapConfiguration gluuLdapConfiguration = this.withVersion(ldapConfiguration);
            this.ldapConfigurationService.update(gluuLdapConfiguration);
            return Response.ok((Object)this.read(ldapConfiguration.getConfigId())).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Create a new configuration", description="Create a new configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=org.gluu.oxtrust.api.server.model.LdapConfigurationDTO.class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createLdapConfiguration(@Valid org.gluu.oxtrust.api.server.model.LdapConfigurationDTO ldapConfiguration) {
        this.log(this.logger, "Create a new configuration");
        try {
            if (this.existingLdapConfigurationValidator.isInvalid(ldapConfiguration)) {
                throw new LdapConfigurationDuplicatedException(ldapConfiguration.getConfigId());
            }
            GluuLdapConfiguration gluuLdapConfiguration = this.ldapConfigurationDtoAssembly.fromDto(ldapConfiguration);
            this.ldapConfigurationService.save(gluuLdapConfiguration);
            return Response.ok((Object)this.read(ldapConfiguration.getConfigId())).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{name}")
    @Operation(summary="Delete an existing configuration", description="Delete an existing configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=org.gluu.oxtrust.api.server.model.LdapConfigurationDTO[].class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteLdapConfigurationByName(@PathParam(value="name") String name) {
        this.log(this.logger, "Delete an existing configuration");
        try {
            this.ldapConfigurationService.remove(name);
            return this.getLdapConfiguration();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/status")
    @Operation(summary="Check status of a configuration", description="Check the status of a configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ConnectionStatusDTO.class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getLdapConfigurationStatus(LdapConnectionData ldapConnectionData) {
        this.log(this.logger, "Check the status of a configuration");
        try {
            ConnectionStatusDTO connectionStatus = ConnectionStatusDTO.from(this.connectionStatus.isUp(ldapConnectionData));
            return Response.ok((Object)connectionStatus).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{name}/status")
    @Operation(summary="Check the status of an existing configuration", description="Check the status of an existing configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ConnectionStatusDTO.class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getLdapConfigurationStatusByName(@PathParam(value="name") String name) {
        this.log(this.logger, "Check the status of an existing configuration");
        try {
            GluuLdapConfiguration ldapConfiguration = this.ldapConfigurationService.findLdapConfigurationByName(name);
            LdapConnectionData ldapConnectionData = LdapConnectionData.from((GluuLdapConfiguration)ldapConfiguration);
            ConnectionStatusDTO connectionStatus = ConnectionStatusDTO.from(this.connectionStatus.isUp(ldapConnectionData));
            return Response.ok((Object)connectionStatus).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private LdapConfigurationDTO read(String name) {
        GluuLdapConfiguration gluuLdapConfiguration = this.ldapConfigurationService.findLdapConfigurationByName(name);
        return this.ldapConfigurationDtoAssembly.toDto(gluuLdapConfiguration);
    }

    private GluuLdapConfiguration withVersion(org.gluu.oxtrust.api.server.model.LdapConfigurationDTO ldapConfiguration) {
        GluuLdapConfiguration result = this.ldapConfigurationDtoAssembly.fromDto(ldapConfiguration);
        this.setupVersion(ldapConfiguration, result);
        return result;
    }

    private void setupVersion(org.gluu.oxtrust.api.server.model.LdapConfigurationDTO ldapConfiguration, GluuLdapConfiguration result) {
        String name = ldapConfiguration.getConfigId();
        GluuLdapConfiguration gluuLdapConfiguration = this.ldapConfigurationService.findLdapConfigurationByName(name);
        result.setVersion(gluuLdapConfiguration.getVersion());
    }
}

