/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.GluuGroupApi;
import org.gluu.oxtrust.api.server.model.GluuPersonApi;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.oxtrust.model.GluuGroup;
import org.gluu.oxtrust.service.GroupService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.oxtrust.service.PersonService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/api/v1/groups")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class GroupWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private GroupService groupService;
    @Inject
    private PersonService personService;
    @Inject
    private OrganizationService organizationService;

    @GET
    @Operation(summary="Get groups", description="Get groups")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuGroupApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listGroups(@DefaultValue(value="0") @QueryParam(value="size") int size) {
        this.log("Get groups");
        try {
            if (size <= 0) {
                return Response.ok(this.convert(this.groupService.getAllGroups())).build();
            }
            return Response.ok(this.convert(this.groupService.getAllGroups(size))).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get group by inum", description="Get a group by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuGroupApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getGroupByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log("Get group having group" + inum);
        inum = inum.equalsIgnoreCase("") ? null : inum;
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            GluuGroup group = this.groupService.getGroupByInum(inum);
            if (group != null) {
                return Response.ok((Object)this.convert(Arrays.asList(group)).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search groups", description="Search groups")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuGroupApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchGroups(@QueryParam(value="pattern") @NotNull String pattern, @DefaultValue(value="1") @QueryParam(value="size") int size) {
        this.log("Search groups with pattern= " + pattern + " and size " + size);
        try {
            List groups = this.groupService.searchGroups(pattern, size);
            return Response.ok(this.convert(groups)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete group", description="Delete a group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteGroup(@PathParam(value="inum") @NotNull String inum) {
        this.log("Delete group having inum " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            GluuGroup group = this.groupService.getGroupByInum(inum);
            if (group != null) {
                this.groupService.removeGroup(group);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update group", description="Update a group")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuGroupApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateGroup(GluuGroupApi group) {
        String inum = group.getInum();
        inum = inum.equalsIgnoreCase("") ? null : inum;
        this.log("Update group " + inum);
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            Objects.requireNonNull(group, "Attempt to update null group");
            GluuGroup existingGroup = this.groupService.getGroupByInum(inum);
            if (existingGroup != null) {
                group.setInum(existingGroup.getInum());
                GluuGroup groupToUpdate = this.updateValues(existingGroup, group);
                groupToUpdate.setDn(this.groupService.getDnForGroup(inum));
                this.groupService.updateGroup(groupToUpdate);
                return Response.ok((Object)this.convert(Arrays.asList(this.groupService.getGroupByInum(inum))).get(0)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add group", description="Add a group")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=GluuGroupApi.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createGroup(GluuGroupApi group) {
        this.log("Adding group " + group.getDisplayName());
        try {
            Objects.requireNonNull(group, "Attempt to create null group");
            GluuGroup gluuGroup = this.copyAttributes(group);
            String inum = gluuGroup.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.groupService.generateInumForNewGroup();
            }
            gluuGroup.setDn(this.groupService.getDnForGroup(inum));
            gluuGroup.setInum(inum);
            this.groupService.addGroup(gluuGroup);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.convert(Arrays.asList(this.groupService.getGroupByInum(inum))).get(0)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}/members")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuPersonApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Operation(summary="Get group members", description="Get a group members")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response getGroupMembers(@PathParam(value="inum") @NotNull String inum) {
        this.log("Get members of group " + inum);
        inum = inum.equalsIgnoreCase("") ? null : inum;
        try {
            Objects.requireNonNull(inum, "inum should not be null");
            GluuGroup group = this.groupService.getGroupByInum(inum);
            ArrayList<String> members = new ArrayList();
            if (group != null) {
                GluuGroupApi gluuGroupApi = this.convert(Arrays.asList(group)).get(0);
                members = gluuGroupApi.getMembers();
                return Response.ok(this.computeMembers(members)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add group member", description="Add group member")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuGroupApi[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{inum}/members/{minum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response addGroupMember(@PathParam(value="inum") @NotNull String groupInum, @PathParam(value="minum") @NotNull String memberInum) {
        this.log("Add member " + memberInum + " to group" + groupInum);
        try {
            Objects.requireNonNull(groupInum, "Group's inum should not be null");
            Objects.requireNonNull(memberInum, "Member's inum should not be null");
            GluuGroup group = this.groupService.getGroupByInum(groupInum);
            GluuCustomPerson person = this.personService.getPersonByInum(memberInum);
            if (group != null && person != null) {
                List<String> members = new ArrayList<String>();
                if (group.getMembers() != null) {
                    members = group.getMembers();
                }
                members.add(this.personService.getDnForPerson(person.getInum()));
                group.setMembers(members);
                this.groupService.updateGroup(group);
                return Response.ok((Object)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Operation(summary="Remove group member", description="Remove a member from group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @Path(value="/{inum}/members/{minum}")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response removeGroupMember(@PathParam(value="inum") @NotNull String groupInum, @PathParam(value="minum") @NotNull String memberInum) {
        this.log("Remove member " + memberInum + " from group" + groupInum);
        try {
            Objects.requireNonNull(groupInum, "Group's inum should not be null");
            Objects.requireNonNull(memberInum, "Member's inum should not be null");
            GluuGroup group = this.groupService.getGroupByInum(groupInum);
            GluuCustomPerson person = this.personService.getPersonByInum(memberInum);
            if (group != null && person != null) {
                ArrayList members = new ArrayList(group.getMembers());
                members.remove(this.personService.getDnForPerson(person.getInum()));
                group.setMembers(members);
                this.groupService.updateGroup(group);
                return Response.ok((Object)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Operation(summary="Delete group member", description="Delete group member")
    @Path(value="/{inum}/members")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteGroupMembers(@PathParam(value="inum") @NotNull String groupInum) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private GluuGroup copyAttributes(GluuGroupApi group) {
        GluuGroup gluuGroup = new GluuGroup();
        gluuGroup.setDescription(group.getDescription());
        gluuGroup.setDisplayName(group.getDisplayName());
        gluuGroup.setOwner(group.getOwner());
        gluuGroup.setStatus(group.getStatus());
        gluuGroup.setOrganization(this.organizationService.getDnForOrganization());
        gluuGroup.setMembers(group.getMembers());
        gluuGroup.setInum(group.getInum());
        return gluuGroup;
    }

    private GluuGroup updateValues(GluuGroup gluuGroup, GluuGroupApi group) {
        gluuGroup.setDescription(group.getDescription());
        gluuGroup.setDisplayName(group.getDisplayName());
        gluuGroup.setOwner(group.getOwner());
        gluuGroup.setStatus(group.getStatus());
        gluuGroup.setOrganization(this.organizationService.getDnForOrganization());
        gluuGroup.setMembers(group.getMembers());
        return gluuGroup;
    }

    private List<GluuPersonApi> computeMembers(List<String> membersDn) {
        ArrayList<GluuPersonApi> gluuCustomPersons = new ArrayList<GluuPersonApi>();
        if (membersDn != null && !membersDn.isEmpty()) {
            membersDn.stream().forEach(e -> gluuCustomPersons.add(new GluuPersonApi(this.personService.getPersonByDn(e))));
        }
        return gluuCustomPersons;
    }

    private List<GluuGroupApi> convert(List<GluuGroup> gluuGroups) {
        ArrayList<GluuGroupApi> result = new ArrayList<GluuGroupApi>();
        gluuGroups.stream().forEach(e -> result.add(new GluuGroupApi((GluuGroup)e)));
        return result;
    }

    private void log(String message) {
        this.logger.debug("################# Request: " + message);
    }
}

