/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.codec.binary.StringUtils;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxtrust.api.server.model.LdapConfigurationDTO;
import org.gluu.oxtrust.service.LdapConfigurationService;
import org.gluu.oxtrust.util.CollectionsUtil;

public class ExistingLdapConfigurationValidator {
    @Inject
    private LdapConfigurationService ldapConfigurationService;

    public boolean isInvalid(LdapConfigurationDTO ldapConfiguration) {
        return FluentIterable.from((Iterable)this.ldapConfigurationService.findLdapConfigurations()).anyMatch(this.havingSamePropertiesAs(ldapConfiguration));
    }

    private Predicate<GluuLdapConfiguration> havingSamePropertiesAs(final LdapConfigurationDTO ldapConfiguration) {
        return new Predicate<GluuLdapConfiguration>(){

            public boolean apply(GluuLdapConfiguration gluuLdapConfiguration) {
                return StringUtils.equals((CharSequence)ldapConfiguration.getConfigId(), (CharSequence)gluuLdapConfiguration.getConfigId()) || CollectionsUtil.equalsUnordered(ldapConfiguration.getServers(), (List)gluuLdapConfiguration.getServersStringsList());
            }
        };
    }
}

