/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.custom.CustomScriptService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/scripts")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class CustomScriptWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private CustomScriptService customScriptService;
    @Inject
    private ConfigurationService configurationService;

    @GET
    @Operation(summary="Get all custom scripts", description="Get all custom scripts")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CustomScript[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listCustomScripts() {
        this.log(this.logger, "Get all custom scripts");
        try {
            List customScripts = this.customScriptService.findAllCustomScripts(null);
            return Response.ok((Object)customScripts).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/type/{type}")
    @Operation(summary="Get person auth scripts", description="Get person authentications scripts")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CustomScript[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listCustomScriptsByType(@PathParam(value="type") @NotNull String type) {
        this.log(this.logger, "Get custom scripts of type: " + type);
        try {
            List allowedCustomScriptTypes = Stream.of(this.configurationService.getCustomScriptTypes()).map(e -> e.getValue()).collect(Collectors.toList());
            if (allowedCustomScriptTypes.contains(type)) {
                List customScripts = this.customScriptService.findAllCustomScripts(null).stream().filter(e -> e.getScriptType().getValue().equalsIgnoreCase(type)).collect(Collectors.toList());
                return Response.ok(customScripts).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e2) {
            this.log(this.logger, e2);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get scripts by inum", description="Get scripts by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CustomScript.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getCustomScriptsByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get scripts by inum");
        try {
            CustomScript script = this.customScriptService.getScriptByInum(inum);
            if (script != null) {
                return Response.ok((Object)script).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add new custom script", description="Add new custom script")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CustomScript.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createCustomScript(CustomScript customScript) {
        this.log(this.logger, "Add new custom script ");
        try {
            Objects.requireNonNull(customScript, "Attempt to create null custom script");
            String inum = customScript.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = UUID.randomUUID().toString();
            }
            customScript.setDn(this.customScriptService.buildDn(inum));
            customScript.setInum(inum);
            this.customScriptService.add(customScript);
            return Response.ok((Object)this.customScriptService.getScriptByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update custom script", description="Update custom script")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CustomScript.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateCustomScript(CustomScript customScript) {
        try {
            Objects.requireNonNull(customScript, "Attempt to update null custom script");
            String inum = customScript.getInum();
            this.log(this.logger, "Update custom script " + inum);
            CustomScript existingScript = this.customScriptService.getScriptByInum(customScript.getInum());
            if (existingScript != null) {
                customScript.setInum(existingScript.getInum());
                this.customScriptService.update(customScript);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete custom script", description="Delete an custom script")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteCustomScript(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Delete custom script" + inum);
        try {
            Objects.requireNonNull(inum);
            CustomScript existingScript = this.customScriptService.getScriptByInum(inum);
            if (existingScript != null) {
                this.customScriptService.remove(existingScript);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

