/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class ConfigurationWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;

    @GET
    @Operation(summary="Get gluu configuration", description="Retrieve gluu configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuConfiguration.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getConfiguration() {
        this.log(this.logger, "Processing get gluu configuration");
        try {
            return Response.ok((Object)this.configurationService.getConfiguration()).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

