/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.OxAuthClient;
import org.gluu.oxtrust.service.ClientService;
import org.gluu.oxtrust.service.ScopeService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/api/v1/clients")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class ClientWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;

    @GET
    @Operation(summary="Get openid connect clients", description="Get openid connect clients")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthClient[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listClients() {
        this.log(this.logger, "Get all clients ");
        try {
            List clientList = this.clientService.getAllClients();
            return Response.ok((Object)clientList).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}/scopes")
    @Operation(summary="Get assigned OIDC client scopes", description="Get OIDC scopes assign to OIDC client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error"), @ApiResponse(responseCode="404", description="Not Found")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getClientScope(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get client scopes");
        try {
            Objects.requireNonNull(inum);
            OxAuthClient client = this.clientService.getClientByInum(inum);
            if (client != null) {
                List scopesDn = client.getOxAuthScopes();
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                if (scopesDn != null) {
                    for (String scopeDn : scopesDn) {
                        scopes.add(this.scopeService.getScopeByDn(scopeDn));
                    }
                    return Response.ok(scopes).build();
                }
                return Response.ok(scopes).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{inum}")
    @Operation(summary="Get OIDC client", description="Get a specific OIDC client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthClient.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getClientByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Get client " + inum);
        try {
            Objects.requireNonNull(inum);
            OxAuthClient client = this.clientService.getClientByInum(inum);
            if (client != null) {
                return Response.ok((Object)client).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search OIDC clients", description="Search OIDC clients")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthClient[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchClients(@QueryParam(value="pattern") @NotNull String pattern, @DefaultValue(value="1") @QueryParam(value="size") int size) {
        this.log(this.logger, "Search client with pattern= " + pattern + " and size " + size);
        try {
            List clients = this.clientService.searchClients(pattern, size);
            return Response.ok((Object)clients).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add OIDC client", description="Add an openidconnect client")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(schema=@Schema(implementation=OxAuthClient.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createClient(OxAuthClient client) {
        this.log(this.logger, "Add new client ");
        try {
            Objects.requireNonNull(client, "Attempt to create null client");
            String inum = client.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.clientService.generateInumForNewClient();
            }
            client.setInum(inum);
            client.setDn(this.clientService.getDnForClient(inum));
            client.setDeletable(client.getClientSecretExpiresAt() != null);
            this.clientService.addClient(client);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.clientService.getClientByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update OIDC client", description="Update openidconnect client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthClient.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateClient(OxAuthClient client) {
        try {
            Objects.requireNonNull(client, "Attempt to update null client");
            String inum = client.getInum();
            this.log(this.logger, "Update client " + inum);
            OxAuthClient existingClient = this.clientService.getClientByInum(inum);
            if (existingClient != null) {
                client.setInum(existingClient.getInum());
                client.setBaseDn(this.clientService.getDnForClient(inum));
                client.setDeletable(client.getClientSecretExpiresAt() != null);
                this.clientService.updateClient(client);
                return Response.ok((Object)this.clientService.getClientByInum(existingClient.getInum())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/{inum}/scopes/{sinum}")
    @Operation(summary="Add OIDC client scopes", description="Add scopes to OIDC client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response addScopeToClient(@PathParam(value="inum") @NotNull String inum, @PathParam(value="sinum") @NotNull String sinum) {
        this.log(this.logger, "add new scope to client");
        try {
            OxAuthClient client = this.clientService.getClientByInum(inum);
            Scope scope = this.scopeService.getScopeByInum(sinum);
            Objects.requireNonNull(client);
            Objects.requireNonNull(scope);
            if (client != null && scope != null) {
                ArrayList<String> scopes = new ArrayList<String>(client.getOxAuthScopes());
                String scopeBaseDn = this.scopeService.getDnForScope(scope.getInum());
                scopes.remove(scopeBaseDn);
                scopes.add(scopeBaseDn);
                client.setOxAuthScopes(scopes);
                this.clientService.updateClient(client);
                return Response.ok(scopes).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}/scopes/{sinum}")
    @Operation(summary="Remove OIDC client scope", description="Remove an existing scope from client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Scope[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response removeScopeToClient(@PathParam(value="inum") @NotNull String inum, @PathParam(value="sinum") @NotNull String sinum) {
        this.log(this.logger, "remove scope to client");
        try {
            OxAuthClient client = this.clientService.getClientByInum(inum);
            Scope scope = this.scopeService.getScopeByInum(sinum);
            Objects.requireNonNull(client);
            Objects.requireNonNull(scope);
            if (client != null && scope != null) {
                ArrayList scopes = new ArrayList(client.getOxAuthScopes());
                scopes.remove(this.scopeService.getDnForScope(scope.getInum()));
                client.setOxAuthScopes(scopes);
                this.clientService.updateClient(client);
                return Response.ok(scopes).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete OIDC client ", description="Delete an openidconnect client")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=OxAuthClient[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteClient(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Delete client " + inum);
        try {
            Objects.requireNonNull(inum);
            OxAuthClient client = this.clientService.getClientByInum(inum);
            if (client != null) {
                this.clientService.removeClient(client);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteClients() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/{inum}/scopes")
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteClientScopes(@PathParam(value="inum") @NotNull String inum) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

