/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.Certificates;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.model.cert.TrustStoreCertificate;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.SSLService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.util.X509CertificateShortInfo;
import org.slf4j.Logger;

@Path(value="/api/v1/certificates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class CertificatesWebResource
extends BaseWebResource {
    private static final String OPENLDAP_CERTIFICATE_FILE = "/etc/certs/openldap.crt";
    private static final String OPENDJ_CERTIFICATE_FILE = "/etc/certs/opendj.crt";
    private static final String HTTPD_CERTIFICATE_FILE = "/etc/certs/httpd.crt";
    private static final String IDP_SIGNING_CERTIFICATE_FILE = "/etc/certs/idp-signing.crt";
    private static final String IDP_ENCRYPT_CERTIFICATE_FILE = "/etc/certs/idp-encryption.crt";
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;
    private List<X509CertificateShortInfo> trustStoreCertificates;
    private List<X509CertificateShortInfo> internalCertificates;

    @GET
    @Operation(summary="List certificates", description="List Gluu Server's certificates. You can get only description of certificates, not keys.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Certificates[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response listCertificates() {
        this.log(this.logger, "Processing certificates retrieval request");
        try {
            ArrayList<X509CertificateShortInfo> certificates = new ArrayList<X509CertificateShortInfo>();
            certificates.addAll(this.trustStoreCertificates());
            certificates.addAll(this.internalCertificates());
            return Response.ok(certificates).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<X509CertificateShortInfo> trustStoreCertificates() {
        try {
            this.trustStoreCertificates = new ArrayList<X509CertificateShortInfo>();
            GluuConfiguration configuration = this.configurationService.getConfiguration();
            List trustStoreCertificatesList = configuration.getTrustStoreCertificates();
            if (trustStoreCertificatesList != null) {
                for (TrustStoreCertificate trustStoreCertificate : trustStoreCertificatesList) {
                    try {
                        X509Certificate[] certs;
                        for (X509Certificate cert : certs = SSLService.loadCertificates((byte[])trustStoreCertificate.getCertificate().getBytes())) {
                            X509CertificateShortInfo entry = new X509CertificateShortInfo(trustStoreCertificate.getName(), cert);
                            this.trustStoreCertificates.add(entry);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Certificate load exception", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Load trustStoreCertificates configuration exception", (Throwable)e);
        }
        return this.trustStoreCertificates;
    }

    private List<X509CertificateShortInfo> internalCertificates() {
        try {
            X509Certificate[] idpEncryptionCerts;
            this.internalCertificates = new ArrayList<X509CertificateShortInfo>();
            try {
                X509Certificate[] openDJCerts;
                for (X509Certificate openDJCert : openDJCerts = SSLService.loadCertificates((InputStream)new FileInputStream(OPENDJ_CERTIFICATE_FILE))) {
                    this.internalCertificates.add(new X509CertificateShortInfo(OPENDJ_CERTIFICATE_FILE, "OpenDJ SSL", openDJCert));
                }
            }
            catch (Exception e) {
                this.logger.warn("OPENDJ certificate load exception");
            }
            try {
                X509Certificate[] httpdCerts;
                for (X509Certificate httpdCert : httpdCerts = SSLService.loadCertificates((InputStream)new FileInputStream(HTTPD_CERTIFICATE_FILE))) {
                    this.internalCertificates.add(new X509CertificateShortInfo(HTTPD_CERTIFICATE_FILE, "HTTPD SSL", httpdCert));
                }
            }
            catch (Exception e) {
                this.logger.warn("HTTPD Certificate load exception");
            }
            try {
                X509Certificate[] idpSigingCerts;
                for (X509Certificate idpSigingCert : idpSigingCerts = SSLService.loadCertificates((InputStream)new FileInputStream(IDP_SIGNING_CERTIFICATE_FILE))) {
                    this.internalCertificates.add(new X509CertificateShortInfo(IDP_SIGNING_CERTIFICATE_FILE, "IDP SIGNING", idpSigingCert));
                }
            }
            catch (Exception e) {
                this.logger.warn("IDP SIGNING certificate load exception");
            }
            try {
                for (X509Certificate idpEncryptionCert : idpEncryptionCerts = SSLService.loadCertificates((InputStream)new FileInputStream(IDP_ENCRYPT_CERTIFICATE_FILE))) {
                    this.internalCertificates.add(new X509CertificateShortInfo(IDP_ENCRYPT_CERTIFICATE_FILE, "IDP ENCRYPTION", idpEncryptionCert));
                }
            }
            catch (Exception e) {
                this.logger.warn("IDP ENCRYPTION certificate load exception");
            }
            try {
                for (X509Certificate idpEncryptionCert : idpEncryptionCerts = SSLService.loadCertificates((InputStream)new FileInputStream(OPENLDAP_CERTIFICATE_FILE))) {
                    this.internalCertificates.add(new X509CertificateShortInfo(OPENLDAP_CERTIFICATE_FILE, "OpenLDAP ENCRYPTION", idpEncryptionCert));
                }
            }
            catch (Exception e) {
                this.logger.warn("OpenLDAP certificate load exception");
            }
        }
        catch (Exception e) {
            this.logger.error("Load internalCertificates configuration exception", (Throwable)e);
        }
        return this.internalCertificates;
    }
}

