/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.CasProtocolDTO;
import org.gluu.oxtrust.api.server.util.CASProtocolConfigurationProvider;
import org.gluu.oxtrust.api.server.util.CasProtocolDtoAssembly;
import org.gluu.oxtrust.service.CASService;
import org.gluu.oxtrust.service.ShibbolethService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.oxtrust.util.CASProtocolConfiguration;
import org.slf4j.Logger;

@Path(value="/api/v1/configuration/cas")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class CasProtocolWebResource
extends BaseWebResource {
    private CASProtocolConfigurationProvider casProtocolConfigurationProvider = new CASProtocolConfigurationProvider();
    private CasProtocolDtoAssembly casProtocolDtoAssembly = new CasProtocolDtoAssembly();
    @Inject
    private Logger logger;
    @Inject
    private CASService casService;
    @Inject
    private ShibbolethService shibbolethService;

    @GET
    @Operation(summary="Get existing configuration", description="Get the existing configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CasProtocolDTO.class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getCasConfig() {
        this.log(this.logger, "Get the existing cas configuration");
        try {
            CASProtocolConfiguration casProtocolConfiguration = this.casProtocolConfigurationProvider.get();
            CasProtocolDTO casProtocolDto = this.casProtocolDtoAssembly.toDto(casProtocolConfiguration);
            return Response.ok((Object)casProtocolDto).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update the configuration", description="Update the configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=CasProtocolDTO.class))}, description="Success")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response update(@Valid CasProtocolDTO casProtocol) {
        this.log(this.logger, "Update the configuration");
        try {
            CASProtocolConfiguration casProtocolConfiguration = this.casProtocolDtoAssembly.fromDto(casProtocol);
            casProtocolConfiguration.save(this.casService);
            this.shibbolethService.update(casProtocolConfiguration);
            return this.getCasConfig();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

