/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.api.server.model.AuthenticationMethod;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Path(value="/api/v1/acrs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class AuthenticationMethodWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationService configurationService;

    @GET
    @Operation(summary="Get current authentication methods", description="Get current authentication methods")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AuthenticationMethod.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getCurrentAuthentication() {
        this.log(this.logger, "Processing getCurrentAuthentication()");
        try {
            GluuConfiguration configuration = this.configurationService.getConfiguration();
            AuthenticationMethod method = new AuthenticationMethod();
            method.setDefaultAcr(configuration.getAuthenticationMode());
            method.setOxtrustAcr(configuration.getOxTrustAuthenticationMode());
            return Response.ok((Object)method).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update authentication methods", description="Update authentication methods")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AuthenticationMethod.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateAuthenticationMethod(AuthenticationMethod method) {
        this.log(this.logger, "Processing updateAuthenticationMethod()");
        try {
            Preconditions.checkNotNull((Object)method, (Object)"Attempt to update null method");
            GluuConfiguration configuration = this.configurationService.getConfiguration();
            if (method.getDefaultAcr() != null || method.getOxtrustAcr() != null) {
                configuration.setAuthenticationMode(method.getDefaultAcr());
                configuration.setOxTrustAuthenticationMode(method.getOxtrustAcr());
                this.configurationService.updateConfiguration(configuration);
                configuration = this.configurationService.getConfiguration();
                method.setDefaultAcr(configuration.getAuthenticationMode());
                method.setOxtrustAcr(configuration.getOxTrustAuthenticationMode());
                return Response.ok((Object)method).build();
            }
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

