/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.server.api.impl;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.model.GluuAttribute;
import org.gluu.model.GluuStatus;
import org.gluu.oxtrust.api.server.api.impl.BaseWebResource;
import org.gluu.oxtrust.service.AttributeService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/api/v1/attributes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class AttributeWebResource
extends BaseWebResource {
    @Inject
    private Logger logger;
    @Inject
    private AttributeService attributeService;

    @GET
    @Operation(summary="Get all attributes", description="Gets all the gluu attributes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute[].class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAllAttributes() {
        this.log(this.logger, "Processing getAllAttributes()");
        try {
            List gluuAttributes = this.attributeService.getAllAttributes();
            return Response.ok((Object)gluuAttributes).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/active")
    @Operation(summary="Get all active attributes", description="Gets all the active gluu attributes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute[].class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAllActiveAttributes() {
        this.log(this.logger, "Processing getAllActivesAttributes()");
        try {
            List gluuAttributes = this.attributeService.getAllAttributes().stream().filter(e -> e.getStatus() == GluuStatus.ACTIVE).collect(Collectors.toList());
            return Response.ok(gluuAttributes).build();
        }
        catch (Exception e2) {
            this.log(this.logger, e2);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/inactive")
    @Operation(summary="Get all inactive attributes", description="Gets all inative attributes")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute[].class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAllInactiveAttributes() {
        this.log(this.logger, "Processing getAllInActivesAttributes()");
        try {
            List gluuAttributes = this.attributeService.getAllAttributes().stream().filter(e -> e.getStatus() == GluuStatus.INACTIVE).collect(Collectors.toList());
            return Response.ok(gluuAttributes).build();
        }
        catch (Exception e2) {
            this.log(this.logger, e2);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/attribute/{inum}")
    @Operation(summary="Get attribute by inum", description="Get an attribute by inum")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response getAttributeByInum(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Processing getAttributeByInum()");
        try {
            Preconditions.checkNotNull((Object)inum);
            return Response.ok((Object)this.attributeService.getAttributeByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/search")
    @Operation(summary="Search attributes", description="Perform an attribute search")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute.class))}, description="success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-read"})
    public Response searchAttributes(@QueryParam(value="pattern") @NotNull String pattern, @DefaultValue(value="1") @QueryParam(value="size") int size) {
        this.log(this.logger, "Processing searchAttributes()");
        try {
            List attributes = this.attributeService.searchAttributes(pattern, size);
            return Response.ok((Object)attributes).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Operation(summary="Add new attribute", description="Adds a new Gluu attribute")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute.class))}, description="Success"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response createAttribute(GluuAttribute gluuAttribute) {
        this.log(this.logger, "Processing createAttribute()");
        try {
            Preconditions.checkNotNull((Object)gluuAttribute, (Object)"Attempt to create null attribute");
            String inum = gluuAttribute.getInum();
            if (StringHelper.isEmpty((String)inum)) {
                inum = this.attributeService.generateInumForNewAttribute();
            }
            gluuAttribute.setInum(inum);
            gluuAttribute.setDn(this.attributeService.getDnForAttribute(inum));
            this.attributeService.addAttribute(gluuAttribute);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.attributeService.getAttributeByInum(inum)).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Operation(summary="Update new attribute", description="Updates a gluu attribute")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GluuAttribute.class))}, description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response updateAttribute(GluuAttribute gluuAttribute) {
        this.log(this.logger, "Processing updateAttribute()");
        try {
            Preconditions.checkNotNull((Object)gluuAttribute, (Object)"Attempt to update null attribute");
            String inum = gluuAttribute.getInum();
            GluuAttribute existingAttribute = this.attributeService.getAttributeByInum(inum);
            if (existingAttribute != null) {
                gluuAttribute.setInum(existingAttribute.getInum());
                this.attributeService.updateAttribute(gluuAttribute);
                return Response.ok((Object)this.attributeService.getAttributeByInum(existingAttribute.getInum())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{inum}")
    @Operation(summary="Delete gluu attribute", description="Deletes a gluu attribute")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="success"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Server error")})
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteAttribute(@PathParam(value="inum") @NotNull String inum) {
        this.log(this.logger, "Processing deleteAttribute()");
        try {
            Preconditions.checkNotNull((Object)inum);
            GluuAttribute gluuAttribute = this.attributeService.getAttributeByInum(inum);
            if (gluuAttribute != null) {
                this.attributeService.removeAttribute(gluuAttribute);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log(this.logger, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @ProtectedApi(scopes={"oxtrust-api-write"})
    public Response deleteAttributes() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

