/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.grizzly;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.glassfish.jersey.test.spi.TestHelper;

public class GrizzlyWebTestContainerFactory
implements TestContainerFactory {
    public TestContainer create(URI baseUri, DeploymentContext context) {
        if (!(context instanceof ServletDeploymentContext)) {
            throw new IllegalArgumentException("The deployment context must be an instance of ServletDeploymentContext.");
        }
        return new GrizzlyWebTestContainer(baseUri, (ServletDeploymentContext)context);
    }

    private static class GrizzlyWebTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyWebTestContainer.class.getName());
        private URI baseUri;
        private final ServletDeploymentContext deploymentContext;
        private HttpServer server;

        private GrizzlyWebTestContainer(URI baseUri, ServletDeploymentContext context) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).path(context.getServletPath()).build(new Object[0]);
            LOGGER.info("Creating GrizzlyWebTestContainer configured at the base URI " + TestHelper.zeroPortToAvailablePort((URI)baseUri));
            this.deploymentContext = context;
            this.instantiateGrizzlyWebServer();
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.WARNING, "Ignoring start request - GrizzlyWebTestContainer is already started.");
            } else {
                LOGGER.log(Level.FINE, "Starting GrizzlyWebTestContainer...");
                try {
                    this.server.start();
                    if (this.baseUri.getPort() == 0) {
                        this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(this.server.getListener("grizzly").getPort()).build(new Object[0]);
                        LOGGER.log(Level.INFO, "Started GrizzlyWebTestContainer at the base URI " + this.baseUri);
                    }
                }
                catch (IOException ioe) {
                    throw new TestContainerException((Throwable)ioe);
                }
            }
        }

        public void stop() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.FINE, "Stopping GrizzlyWebTestContainer...");
                this.server.shutdownNow();
            } else {
                LOGGER.log(Level.WARNING, "Ignoring stop request - GrizzlyWebTestContainer is already stopped.");
            }
        }

        private void instantiateGrizzlyWebServer() {
            String servletPathLocal;
            String contextPathLocal = this.deploymentContext.getContextPath();
            if (!contextPathLocal.isEmpty() && !contextPathLocal.startsWith("/")) {
                contextPathLocal = "/" + contextPathLocal;
            }
            if (!(servletPathLocal = this.deploymentContext.getServletPath()).startsWith("/")) {
                servletPathLocal = "/" + servletPathLocal;
            }
            servletPathLocal = servletPathLocal.endsWith("/") ? servletPathLocal + "*" : servletPathLocal + "/*";
            WebappContext context = new WebappContext("TestContext", contextPathLocal);
            HttpServlet servletInstance = this.deploymentContext.getServletInstance();
            Class servletClass = this.deploymentContext.getServletClass();
            if (servletInstance != null || servletClass != null) {
                ServletRegistration registration = servletInstance != null ? context.addServlet(servletInstance.getClass().getName(), (Servlet)servletInstance) : context.addServlet(servletClass.getName(), servletClass);
                registration.setInitParameters(this.deploymentContext.getInitParams());
                registration.addMapping(new String[]{servletPathLocal});
            }
            for (Iterator eventListener : this.deploymentContext.getListeners()) {
                context.addListener((Class)((Object)eventListener));
            }
            Map contextParams = this.deploymentContext.getContextParams();
            for (String contextParamName : contextParams.keySet()) {
                context.addContextInitParameter(contextParamName, (String)contextParams.get(contextParamName));
            }
            if (this.deploymentContext.getFilters() != null) {
                for (ServletDeploymentContext.FilterDescriptor filterDescriptor : this.deploymentContext.getFilters()) {
                    FilterRegistration filterRegistration = context.addFilter(filterDescriptor.getFilterName(), filterDescriptor.getFilterClass());
                    filterRegistration.setInitParameters(filterDescriptor.getInitParams());
                    filterRegistration.addMappingForUrlPatterns(this.grizzlyDispatcherTypes(filterDescriptor.getDispatcherTypes()), true, new String[]{servletPathLocal});
                }
            }
            try {
                this.server = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (GrizzlyHttpContainer)null, (boolean)false, null, (boolean)false);
                context.deploy(this.server);
            }
            catch (ProcessingException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        private EnumSet<DispatcherType> grizzlyDispatcherTypes(Set<DispatcherType> dispatcherTypes) {
            HashSet<DispatcherType> grizzlyDispatcherTypes = new HashSet<DispatcherType>();
            for (DispatcherType servletDispatchType : dispatcherTypes) {
                grizzlyDispatcherTypes.add(DispatcherType.valueOf((String)servletDispatchType.name()));
            }
            return EnumSet.copyOf(grizzlyDispatcherTypes);
        }
    }
}

