/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.guava.common.primitives;

import java.math.BigInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.forgerock.guava.common.annotations.GwtCompatible;
import org.forgerock.guava.common.annotations.GwtIncompatible;
import org.forgerock.guava.common.base.Preconditions;
import org.forgerock.guava.common.primitives.UnsignedInts;

@GwtCompatible(emulated=true)
public final class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    public static final UnsignedInteger ZERO = UnsignedInteger.fromIntBits(0);
    public static final UnsignedInteger ONE = UnsignedInteger.fromIntBits(1);
    public static final UnsignedInteger MAX_VALUE = UnsignedInteger.fromIntBits(-1);
    private final int value;

    private UnsignedInteger(int value) {
        this.value = value & 0xFFFFFFFF;
    }

    public static UnsignedInteger fromIntBits(int bits) {
        return new UnsignedInteger(bits);
    }

    public static UnsignedInteger valueOf(long value) {
        Preconditions.checkArgument(((value & 0xFFFFFFFFL) == value ? 1 : 0) != 0, (String)"value (%s) is outside the range for an unsigned integer value", (Object[])new Object[]{value});
        return UnsignedInteger.fromIntBits((int)value);
    }

    public static UnsignedInteger valueOf(BigInteger value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.signum() >= 0 && value.bitLength() <= 32 ? 1 : 0) != 0, (String)"value (%s) is outside the range for an unsigned integer value", (Object[])new Object[]{value});
        return UnsignedInteger.fromIntBits(value.intValue());
    }

    public static UnsignedInteger valueOf(String string) {
        return UnsignedInteger.valueOf(string, 10);
    }

    public static UnsignedInteger valueOf(String string, int radix) {
        return UnsignedInteger.fromIntBits(UnsignedInts.parseUnsignedInt(string, radix));
    }

    @CheckReturnValue
    public UnsignedInteger plus(UnsignedInteger val) {
        return UnsignedInteger.fromIntBits(this.value + ((UnsignedInteger)Preconditions.checkNotNull((Object)val)).value);
    }

    @CheckReturnValue
    public UnsignedInteger minus(UnsignedInteger val) {
        return UnsignedInteger.fromIntBits(this.value - ((UnsignedInteger)Preconditions.checkNotNull((Object)val)).value);
    }

    @CheckReturnValue
    @GwtIncompatible(value="Does not truncate correctly")
    public UnsignedInteger times(UnsignedInteger val) {
        return UnsignedInteger.fromIntBits(this.value * ((UnsignedInteger)Preconditions.checkNotNull((Object)val)).value);
    }

    @CheckReturnValue
    public UnsignedInteger dividedBy(UnsignedInteger val) {
        return UnsignedInteger.fromIntBits(UnsignedInts.divide(this.value, ((UnsignedInteger)Preconditions.checkNotNull((Object)val)).value));
    }

    @CheckReturnValue
    public UnsignedInteger mod(UnsignedInteger val) {
        return UnsignedInteger.fromIntBits(UnsignedInts.remainder(this.value, ((UnsignedInteger)Preconditions.checkNotNull((Object)val)).value));
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return UnsignedInts.toLong(this.value);
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public int compareTo(UnsignedInteger other) {
        Preconditions.checkNotNull((Object)other);
        return UnsignedInts.compare(this.value, other.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnsignedInteger) {
            UnsignedInteger other = (UnsignedInteger)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return UnsignedInts.toString(this.value, radix);
    }
}

