/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;

public abstract class AbstractRouter<T extends AbstractRouter<T, R, H, D>, R, H, D>
implements Describable<D, R>,
Describable.Listener {
    private final Map<RouteMatcher<R>, H> routes = new ConcurrentHashMap<RouteMatcher<R>, H>();
    protected final RouteMatcher<R> thisRouterUriMatcher = this.uriMatcher(RoutingMode.EQUALS, "");
    private final List<Describable.Listener> apiListeners = new CopyOnWriteArrayList<Describable.Listener>();
    private volatile H defaultRoute;
    private ApiProducer<D> apiProducer;
    protected D api;

    protected AbstractRouter() {
    }

    protected AbstractRouter(AbstractRouter<T, R, H, D> router) {
        this.defaultRoute = router.defaultRoute;
        this.addAllRoutes(router);
    }

    protected abstract T getThis();

    protected final Map<RouteMatcher<R>, H> getRoutes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public final T addAllRoutes(T router) {
        if (this != router) {
            boolean descriptorChanged = false;
            for (Map.Entry<RouteMatcher<R>, H> route : ((AbstractRouter)router).getRoutes().entrySet()) {
                H handler = route.getValue();
                descriptorChanged |= this.updateApiDescriptor(this.routes.put(route.getKey(), handler), handler);
            }
            if (descriptorChanged) {
                this.notifyDescriptorChange();
            }
        }
        return this.getThis();
    }

    public final T addRoute(RouteMatcher<R> matcher, H handler) {
        return this.updateApiDescriptorAndNotify(this.routes.put(matcher, handler), handler);
    }

    private boolean updateApiDescriptor(H oldHandler, H newHandler) {
        boolean oldHandlerDescribable = oldHandler instanceof Describable;
        boolean newHandlerDescribable = newHandler instanceof Describable;
        if (oldHandlerDescribable) {
            ((Describable)oldHandler).removeDescriptorListener(this);
        }
        if (newHandlerDescribable) {
            ((Describable)newHandler).addDescriptorListener(this);
        }
        return oldHandlerDescribable || newHandlerDescribable;
    }

    private T updateApiDescriptorAndNotify(H oldHandler, H newHandler) {
        if (this.updateApiDescriptor(oldHandler, newHandler)) {
            this.notifyDescriptorChange();
        }
        return this.getThis();
    }

    public final T setDefaultRoute(H handler) {
        H oldDefault = this.defaultRoute;
        this.defaultRoute = handler;
        return this.updateApiDescriptorAndNotify(oldDefault, handler);
    }

    final H getDefaultRoute() {
        return this.defaultRoute;
    }

    public final T removeAllRoutes() {
        this.routes.clear();
        this.api = null;
        return this.getThis();
    }

    @SafeVarargs
    public final boolean removeRoute(RouteMatcher<R> ... routes) {
        boolean isModified = false;
        boolean apiDescriptorModified = false;
        for (RouteMatcher<R> route : routes) {
            H removed = this.routes.remove(route);
            isModified |= removed != null;
            apiDescriptorModified |= this.updateApiDescriptor(removed, null);
        }
        if (apiDescriptorModified) {
            this.notifyDescriptorChange();
        }
        return isModified;
    }

    protected Pair<Context, H> getBestRoute(Context context, R request) throws IncomparableRouteMatchException {
        Object handler = null;
        RouteMatch bestMatch = null;
        for (Map.Entry<RouteMatcher<R>, H> route : this.routes.entrySet()) {
            RouteMatch result = route.getKey().evaluate(context, request);
            if (result == null || !result.isBetterMatchThan(bestMatch)) continue;
            handler = route.getValue();
            bestMatch = result;
        }
        if (bestMatch != null) {
            return Pair.of((Object)bestMatch.decorateContext(context), handler);
        }
        H dftRoute = this.defaultRoute;
        return dftRoute != null ? Pair.of((Object)context, dftRoute) : null;
    }

    @Override
    public synchronized D api(ApiProducer<D> producer) {
        if (this.apiProducer == null) {
            this.apiProducer = producer;
            this.updateApi();
        }
        return this.api;
    }

    private void updateApi() {
        if (this.apiProducer != null) {
            this.api = this.buildApi(this.apiProducer);
        }
    }

    protected D buildApi(ApiProducer<D> producer) {
        ArrayList<D> descriptors = new ArrayList<D>(this.routes.size());
        for (Map.Entry<RouteMatcher<R>, H> route : this.routes.entrySet()) {
            H handler = route.getValue();
            if (!(handler instanceof Describable)) continue;
            RouteMatcher<R> matcher = route.getKey();
            D descriptor = ((Describable)handler).api(producer.newChildProducer(matcher.idFragment()));
            descriptors.add(matcher.transformApi(descriptor, producer));
        }
        H dftRoute = this.defaultRoute;
        if (dftRoute instanceof Describable) {
            descriptors.add(((Describable)dftRoute).api(producer));
        }
        return descriptors.isEmpty() ? null : (D)producer.merge(descriptors);
    }

    protected abstract RouteMatcher<R> uriMatcher(RoutingMode var1, String var2);

    @Override
    public D handleApiRequest(Context context, R request) {
        try {
            Object handler;
            Pair<Context, H> bestRoute = this.getBestRoute(context, request);
            Object object = handler = bestRoute != null ? bestRoute.getSecond() : null;
            if (handler instanceof Describable) {
                Context nextContext = (Context)bestRoute.getFirst();
                return ((Describable)handler).handleApiRequest(nextContext, request);
            }
        }
        catch (IncomparableRouteMatchException e) {
            throw new IllegalStateException(e);
        }
        if (this.thisRouterUriMatcher.evaluate(context, request) != null) {
            return this.api;
        }
        throw new UnsupportedOperationException("No route matched the request " + request);
    }

    private void notifyListeners() {
        for (Describable.Listener listener : this.apiListeners) {
            listener.notifyDescriptorChange();
        }
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        this.apiListeners.add(listener);
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        this.apiListeners.remove(listener);
    }

    @Override
    public void notifyDescriptorChange() {
        this.updateApi();
        this.notifyListeners();
    }
}

