/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.util.Factory;

public final class PipeBufferedStream {
    private final OutputStream outputStream;
    private final BranchingInputStream inputStream;
    private final AtomicInteger bufferRefCount = new AtomicInteger(2);
    private final Buffer buffer;
    private int position = 0;

    public PipeBufferedStream() {
        this(IO.newTemporaryStorage());
    }

    public PipeBufferedStream(Factory<Buffer> bufferFactory) {
        this.outputStream = new PipeOutputStream();
        this.inputStream = IO.newBranchingInputStream(new PipeInputStream(), bufferFactory);
        this.buffer = (Buffer)bufferFactory.newInstance();
    }

    public OutputStream getIn() {
        return this.outputStream;
    }

    public BranchingInputStream getOut() {
        return this.inputStream;
    }

    private void closeBufferIfNeeded() throws IOException {
        if (this.bufferRefCount.decrementAndGet() == 0) {
            this.buffer.close();
        }
    }

    private class PipeInputStream
    extends InputStream {
        private PipeInputStream() {
        }

        @Override
        public int read() throws IOException {
            return PipeBufferedStream.this.position < PipeBufferedStream.this.buffer.length() ? (int)PipeBufferedStream.this.buffer.read(PipeBufferedStream.this.position++) : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (PipeBufferedStream.this.position < PipeBufferedStream.this.buffer.length()) {
                int readLength = PipeBufferedStream.this.buffer.read(PipeBufferedStream.this.position, b, off, len);
                PipeBufferedStream.this.position += readLength;
                return readLength;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            PipeBufferedStream.this.closeBufferIfNeeded();
        }
    }

    private class PipeOutputStream
    extends OutputStream {
        private PipeOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            PipeBufferedStream.this.buffer.append((byte)i);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            PipeBufferedStream.this.buffer.append(b, off, len);
        }

        @Override
        public void close() throws IOException {
            PipeBufferedStream.this.closeBufferIfNeeded();
        }
    }
}

