/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.async;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.forgerock.http.apache.AbstractHttpClient;
import org.forgerock.http.apache.async.CloseableBufferFactory;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.PipeBufferedStream;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.Factory;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AsyncHttpClient
extends AbstractHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final CloseableHttpAsyncClient client;
    private final Factory<Buffer> storage;
    private final CloseableBufferFactory<ByteBuffer> bufferFactory;

    AsyncHttpClient(CloseableHttpAsyncClient client, Factory<Buffer> storage, int threadCount) {
        this.client = client;
        this.storage = storage;
        this.bufferFactory = CloseableBufferFactory.closeableByteBufferFactory(threadCount, 8192);
    }

    public Promise<Response, NeverThrowsException> sendAsync(Request request) {
        HttpUriRequest clientRequest = this.createHttpUriRequest(request);
        PromiseImpl promise = PromiseImpl.create();
        Object httpAsyncResponseConsumer = new PromiseHttpAsyncResponseConsumer((PromiseImpl<Response, NeverThrowsException>)promise, request.getUri().asURI().toASCIIString(), this.storage, this.bufferFactory);
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            httpAsyncResponseConsumer = new MdcAwareHttpAsyncResponseConsumer((HttpAsyncResponseConsumer<HttpResponse>)httpAsyncResponseConsumer, mdc);
        }
        this.client.execute(HttpAsyncMethods.create((HttpUriRequest)clientRequest), (HttpAsyncResponseConsumer)httpAsyncResponseConsumer, null);
        return promise;
    }

    public void close() throws IOException {
        this.client.close();
    }

    private static final class MdcAwareHttpAsyncResponseConsumer
    implements HttpAsyncResponseConsumer<HttpResponse> {
        private final HttpAsyncResponseConsumer<HttpResponse> delegate;
        private final Map<String, String> mdc;

        MdcAwareHttpAsyncResponseConsumer(HttpAsyncResponseConsumer<HttpResponse> delegate, Map<String, String> mdc) {
            this.delegate = delegate;
            this.mdc = mdc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.responseReceived(response);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.consumeContent(decoder, ioctrl);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void responseCompleted(HttpContext context) {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.responseCompleted(context);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception ex) {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.failed(ex);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        public Exception getException() {
            return this.delegate.getException();
        }

        public HttpResponse getResult() {
            return (HttpResponse)this.delegate.getResult();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.close();
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                boolean bl = this.delegate.cancel();
                return bl;
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        private void restoreMdc(Map<String, String> previous) {
            if (previous != null) {
                MDC.setContextMap(previous);
            } else {
                MDC.clear();
            }
        }
    }

    static final class PromiseHttpAsyncResponseConsumer
    implements HttpAsyncResponseConsumer<HttpResponse> {
        private final PromiseImpl<Response, NeverThrowsException> promise;
        private final Factory<Buffer> storage;
        private final String uri;
        private final CloseableBufferFactory<ByteBuffer> bufferFactory;
        private Response response;
        private WritableByteChannel channel;
        private HttpResponse result;
        private Exception exception;

        PromiseHttpAsyncResponseConsumer(PromiseImpl<Response, NeverThrowsException> promise, String uri, Factory<Buffer> storage, CloseableBufferFactory<ByteBuffer> bufferFactory) {
            this.promise = promise;
            this.storage = storage;
            this.uri = uri;
            this.bufferFactory = bufferFactory;
        }

        public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
            this.result = httpResponse;
            this.response = AsyncHttpClient.createResponseWithoutEntity((HttpResponse)httpResponse);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                PipeBufferedStream pipe = new PipeBufferedStream(this.storage);
                this.channel = Channels.newChannel(pipe.getIn());
                this.response.getEntity().setRawContentInputStream(pipe.getOut());
            }
        }

        public void consumeContent(ContentDecoder contentDecoder, IOControl ioControl) throws IOException {
            try (CloseableBufferFactory.CloseableBuffer buffer = this.bufferFactory.newInstance();){
                ByteBuffer byteBuffer = (ByteBuffer)buffer.getBuffer();
                while (contentDecoder.read(byteBuffer) > 0) {
                    byteBuffer.flip();
                    this.channel.write(byteBuffer);
                    byteBuffer.clear();
                }
            }
            if (contentDecoder.isCompleted()) {
                this.channel.close();
            }
        }

        public void responseCompleted(HttpContext httpContext) {
            this.promise.handleResult((Object)this.response);
        }

        public void failed(Exception e) {
            Utils.closeSilently((Closeable[])new Closeable[]{this.response, this.channel});
            this.exception = e;
            logger.trace("Failed to obtain response for {}", (Object)this.uri, (Object)e);
            this.promise.handleResult((Object)new Response(Status.BAD_GATEWAY).setCause(e));
        }

        public Exception getException() {
            return this.exception;
        }

        public HttpResponse getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.promise.isDone();
        }

        public void close() throws IOException {
        }

        public boolean cancel() {
            return false;
        }
    }
}

