/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ref;

import com.persistit.ref.PersistitReference;
import java.lang.ref.WeakReference;

public abstract class AbstractWeakReference
implements PersistitReference {
    protected Object _id;
    protected transient WeakReference _weakReference;
    protected boolean _knownNull;

    protected AbstractWeakReference() {
    }

    protected AbstractWeakReference(Object id, Object referent) {
        this._id = id;
        if (referent == null) {
            this._knownNull = true;
        } else {
            this._weakReference = new WeakReference<Object>(referent);
        }
    }

    protected AbstractWeakReference(Object id) {
        this._id = id;
        this._weakReference = null;
        this._knownNull = false;
    }

    @Override
    public Object get() {
        if (this._id == null) {
            throw new IllegalStateException("identifier not initialized");
        }
        if (this._knownNull) {
            return null;
        }
        Object referent = null;
        if (this._weakReference != null) {
            referent = this._weakReference.get();
        }
        if (referent == null) {
            referent = this.lookup(this._id);
            if (referent == null) {
                this._knownNull = true;
            } else {
                this._weakReference = new WeakReference<Object>(referent);
            }
        }
        return this._weakReference;
    }

    protected abstract Object lookup(Object var1);
}

