/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public class DefaultPersistitLogger
implements PersistitLogger {
    private volatile PrintWriter _logWriter;
    private final String _logFileName;
    private PersistitLevel _level = PersistitLevel.INFO;

    public DefaultPersistitLogger() {
        this(null);
    }

    public DefaultPersistitLogger(String fileName) {
        this._logFileName = fileName;
    }

    public void setLevel(String levelName) {
        try {
            this.setLevel(PersistitLevel.valueOf(levelName));
        }
        catch (EnumConstantNotPresentException e) {
            this.log(PersistitLevel.WARNING, "No such log level " + levelName);
            this.setLevel(PersistitLevel.INFO);
        }
    }

    public void setLevel(PersistitLevel level) {
        this._level = level;
    }

    public PersistitLevel getLevel() {
        return this._level;
    }

    @Override
    public void log(PersistitLevel level, String message) {
        PrintWriter logWriter = this._logWriter;
        if (logWriter == null && level.compareTo(PersistitLevel.WARNING) >= 0 || level.compareTo(PersistitLevel.WARNING) >= 0) {
            System.err.println(message);
        }
        if (logWriter != null) {
            logWriter.println(message);
        }
    }

    @Override
    public boolean isLoggable(PersistitLevel level) {
        return level.compareTo(this._level) >= 0;
    }

    @Override
    public void open() throws Exception {
        if (this._logWriter != null) {
            throw new IllegalStateException("Log already open");
        }
        if (this._logFileName != null) {
            this._logWriter = new PrintWriter(new BufferedWriter(new FileWriter(this._logFileName)));
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.flush();
        PrintWriter logWriter = this._logWriter;
        if (logWriter != null) {
            logWriter.close();
        }
        this._logWriter = null;
    }

    @Override
    public void flush() {
        PrintWriter logWriter = this._logWriter;
        if (logWriter != null) {
            logWriter.flush();
        }
    }
}

