/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.ValueHelper;
import com.persistit.Volume;
import com.persistit.exception.BufferSizeUnavailableException;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.InUseException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.util.Debug;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class VolumeStructure {
    static final String DIRECTORY_TREE_NAME = "_directory";
    static final String TREE_ROOT = "root";
    static final String TREE_STATS = "stats";
    static final String TREE_ACCUMULATOR = "totals";
    static final long INVALID_PAGE_ADDRESS = -1L;
    private final Persistit _persistit;
    private final Volume _volume;
    private final int _pageSize;
    private BufferPool _pool;
    private volatile long _directoryRootPage;
    private volatile long _garbageRoot;
    private final Map<String, WeakReference<Tree>> _treeNameHashMap = new HashMap<String, WeakReference<Tree>>();
    private Tree _directoryTree;

    VolumeStructure(Persistit persistit, Volume volume, int pageSize) {
        this._persistit = persistit;
        this._volume = volume;
        this._pageSize = pageSize;
        this._pool = persistit.getBufferPool(this._pageSize);
    }

    void init(long directoryRootPage, long garbageRootPage) throws PersistitException {
        this._garbageRoot = garbageRootPage;
        this._directoryRootPage = directoryRootPage;
        if (directoryRootPage != 0L) {
            this._directoryTree = new Tree(this._persistit, this._volume, DIRECTORY_TREE_NAME);
            this._directoryTree.setRootPageAddress(directoryRootPage);
        } else {
            this._directoryTree = new Tree(this._persistit, this._volume, DIRECTORY_TREE_NAME);
            long rootPageAddr = this.createTreeRoot(this._directoryTree);
            this._directoryTree.setRootPageAddress(rootPageAddr);
            this.updateDirectoryTree(this._directoryTree);
        }
        if (!this._volume.isTemporary()) {
            this._directoryTree.loadHandle();
        }
        this._directoryTree.setValid();
    }

    void close() throws PersistitInterruptedException {
        this.truncate();
        this._directoryRootPage = 0L;
        this._garbageRoot = 0L;
        this._directoryTree = null;
        this._persistit.removeVolume(this._volume);
        this._pool = null;
    }

    synchronized void truncate() {
        long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
        for (WeakReference<Tree> treeRef : this._treeNameHashMap.values()) {
            Tree tree = (Tree)treeRef.get();
            if (tree == null) continue;
            tree.invalidate();
        }
        this._treeNameHashMap.clear();
        this._persistit.getJournalManager().truncate(this._volume, timestamp);
    }

    Exchange directoryExchange() throws BufferSizeUnavailableException {
        Exchange ex = new Exchange(this._directoryTree);
        return ex;
    }

    Exchange accumulatorExchange() throws BufferSizeUnavailableException {
        return new Exchange(this._directoryTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createTreeRoot(Tree tree) throws PersistitException {
        this._persistit.checkSuspended();
        Buffer rootPageBuffer = null;
        rootPageBuffer = this.allocPage();
        long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
        rootPageBuffer.writePageOnCheckpoint(timestamp);
        long rootPage = rootPageBuffer.getPageAddress();
        try {
            rootPageBuffer.init(1);
            rootPageBuffer.putValue(Key.LEFT_GUARD_KEY, ValueHelper.EMPTY_VALUE_WRITER);
            rootPageBuffer.putValue(Key.RIGHT_GUARD_KEY, ValueHelper.EMPTY_VALUE_WRITER);
            rootPageBuffer.setDirtyAtTimestamp(timestamp);
        }
        finally {
            rootPageBuffer = this.releaseBuffer(rootPageBuffer);
        }
        return rootPage;
    }

    public synchronized Tree getTree(String name, boolean createIfNecessary) throws PersistitException {
        if (DIRECTORY_TREE_NAME.equals(name)) {
            throw new IllegalArgumentException("Tree name is reserved: " + name);
        }
        Tree tree = null;
        WeakReference<Tree> treeRef = this._treeNameHashMap.get(name);
        if (treeRef != null && (tree = (Tree)treeRef.get()) != null) {
            if (tree.isLive()) {
                return tree;
            }
            if (!createIfNecessary) {
                return null;
            }
        }
        if (tree == null) {
            tree = new Tree(this._persistit, this._volume, name);
        }
        Exchange ex = this.directoryExchange();
        ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_ROOT).append(name);
        Value value = ex.fetch().getValue();
        if (value.isDefined()) {
            value.get(tree);
            this.loadTreeStatistics(tree);
            tree.setPrimordial();
            tree.setValid();
        } else if (createIfNecessary) {
            long rootPageAddr = this.createTreeRoot(tree);
            tree.setRootPageAddress(rootPageAddr);
            this.updateDirectoryTree(tree);
            this.storeTreeStatistics(tree);
            tree.setValid();
        } else {
            return null;
        }
        if (this._volume.isTemporary() || this._volume.isLockVolume()) {
            tree.setPrimordial();
        }
        if (!this._volume.isTemporary()) {
            tree.loadHandle();
        }
        this._treeNameHashMap.put(name, new WeakReference<Tree>(tree));
        return tree;
    }

    Tree getTreeInternal(String name) throws PersistitException {
        if (DIRECTORY_TREE_NAME.equals(name)) {
            return this._directoryTree;
        }
        return this.getTree(name, false);
    }

    void updateDirectoryTree(Tree tree) throws PersistitException {
        if (tree == this._directoryTree) {
            this._volume.getStorage().claimHeadBuffer();
            try {
                this._directoryRootPage = tree.getRootPageAddr();
                this._volume.getStorage().flushMetaData();
            }
            finally {
                this._volume.getStorage().releaseHeadBuffer();
            }
        } else {
            Exchange ex = this.directoryExchange();
            if (!tree.isTransactionPrivate(false) || this._volume.isLockVolume()) {
                ex.ignoreTransactions();
            }
            ex.getValue().put(tree);
            ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_ROOT).append(tree.getName()).store();
        }
    }

    void storeTreeStatistics(Tree tree) throws PersistitException {
        Exchange ex;
        if (tree.isLive() && tree.getStatistics().isDirty() && tree != this._directoryTree && !(ex = this.directoryExchange()).getVolume().isReadOnly()) {
            ex.getValue().put(tree.getStatistics());
            ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_STATS).append(tree.getName()).store();
            tree.getStatistics().setDirty(false);
        }
    }

    void loadTreeStatistics(Tree tree) throws PersistitException {
        Exchange ex = this.directoryExchange();
        ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_STATS).append(tree.getName()).fetch();
        if (ex.getValue().isDefined()) {
            ex.getValue().get(tree.getStatistics());
        }
    }

    void removeTree(Tree tree) throws PersistitException {
        if (tree == this._directoryTree) {
            throw new IllegalArgumentException("Can't delete the Directory tree");
        }
        if (!tree.claim(true)) {
            throw new InUseException("Unable to acquire writer claim on " + tree);
        }
        try {
            Exchange ex = this.directoryExchange();
            ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_ROOT).append(tree.getName()).remove(Key.GTEQ);
            ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_STATS).append(tree.getName()).remove(Key.GTEQ);
            ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_ACCUMULATOR).append(tree.getName()).remove(Key.GTEQ);
            tree.delete();
        }
        finally {
            tree.release();
        }
    }

    synchronized void removed(Tree tree) {
        this._treeNameHashMap.remove(tree.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deallocateTree(long treeRootPage, int treeDepth) throws PersistitException {
        int depth = treeDepth;
        long page = treeRootPage;
        while (page != -1L) {
            Buffer buffer = null;
            long deallocate = -1L;
            try {
                buffer = this._pool.get(this._volume, page, false, true);
                if (buffer.getPageType() != depth) {
                    throw new CorruptVolumeException(buffer + " type code=" + buffer.getPageType() + " is not equal to expected value " + depth);
                }
                if (buffer.isIndexPage()) {
                    deallocate = page;
                    int p = buffer.toKeyBlock(0);
                    page = p > 0 ? buffer.getPointer(p) : -1L;
                    --depth;
                } else if (buffer.isDataPage()) {
                    deallocate = page;
                    page = -1L;
                }
                buffer = this.releaseBuffer(buffer);
            }
            catch (Throwable throwable) {
                buffer = this.releaseBuffer(buffer);
                throw throwable;
            }
            if (deallocate == -1L) continue;
            this.deallocateGarbageChain(deallocate, 0L);
        }
    }

    void recreateTree(Tree tree) throws PersistitException {
        Debug.$assert1.t(tree.getDepth() == -1);
        long rootPageAddr = this.createTreeRoot(tree);
        tree.setRootPageAddress(rootPageAddr);
        this.updateDirectoryTree(tree);
        tree.getStatistics().reset();
        this.storeTreeStatistics(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushStatistics() throws PersistitException {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        VolumeStructure volumeStructure = this;
        synchronized (volumeStructure) {
            for (WeakReference<Tree> ref : this._treeNameHashMap.values()) {
                Tree tree = (Tree)ref.get();
                if (tree == null || tree == this._directoryTree) continue;
                trees.add(tree);
            }
        }
        for (Tree tree : trees) {
            this.storeTreeStatistics(tree);
        }
    }

    public String[] getTreeNames() throws PersistitException {
        ArrayList<String> list = new ArrayList<String>();
        Exchange ex = this.directoryExchange();
        ex.clear().append(DIRECTORY_TREE_NAME).append(TREE_ROOT).append("");
        while (ex.next()) {
            String treeName = ex.getKey().indexTo(-1).decodeString();
            list.add(treeName);
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    Management.TreeInfo getTreeInfo(String name) {
        try {
            Tree tree = this.getTree(name, false);
            if (tree != null) {
                return new Management.TreeInfo(tree);
            }
            return null;
        }
        catch (PersistitException pe) {
            return null;
        }
    }

    synchronized List<Tree> referencedTrees() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        for (WeakReference<Tree> ref : this._treeNameHashMap.values()) {
            Tree tree = (Tree)ref.get();
            if (tree == null) continue;
            list.add(tree);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer allocPage() throws PersistitException {
        Buffer buffer;
        block15: {
            buffer = null;
            this._volume.getStorage().claimHeadBuffer();
            try {
                Buffer buffer2;
                block16: {
                    ArrayList<Chain> chains = new ArrayList<Chain>();
                    long garbageRoot = this.getGarbageRoot();
                    if (garbageRoot == 0L) break block15;
                    Buffer garbageBuffer = this._pool.get(this._volume, garbageRoot, true, true);
                    try {
                        long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                        garbageBuffer.writePageOnCheckpoint(timestamp);
                        assert (garbageBuffer.isGarbagePage()) : "Garbage root page wrong type: " + garbageBuffer;
                        long page = garbageBuffer.getGarbageChainLeftPage();
                        long rightPage = garbageBuffer.getGarbageChainRightPage();
                        assert (page != 0L && page != garbageRoot) : "Garbage chain in garbage page + " + garbageBuffer + " has invalid left page address " + page;
                        if (page == -1L) {
                            long newGarbageRoot = garbageBuffer.getRightSibling();
                            this._persistit.getLogBase().garbagePageExhausted.log(garbageRoot, newGarbageRoot, this.garbageBufferInfo(garbageBuffer));
                            this.setGarbageRoot(newGarbageRoot);
                            buffer = garbageBuffer;
                            garbageBuffer = null;
                        } else {
                            this._persistit.getLogBase().allocateFromGarbageChain.log(page, this.garbageBufferInfo(garbageBuffer));
                            assert (rightPage != -1L) : "Garbage chain in garbage page + " + garbageBuffer + " has invalid right page address " + rightPage;
                            buffer = this._pool.get(this._volume, page, true, true);
                            buffer.writePageOnCheckpoint(timestamp);
                            long nextGarbagePage = buffer.getRightSibling();
                            if (nextGarbagePage == rightPage || nextGarbagePage == 0L) {
                                this._persistit.getLogBase().garbageChainDone.log(this.garbageBufferInfo(garbageBuffer), rightPage);
                                garbageBuffer.removeGarbageChain();
                            } else {
                                this._persistit.getLogBase().garbageChainUpdate.log(this.garbageBufferInfo(garbageBuffer), nextGarbagePage, rightPage);
                                assert (nextGarbagePage > 0L) : "Deallocated page has invalid right pointer " + nextGarbagePage + " in " + buffer;
                                garbageBuffer.setGarbageLeftPage(nextGarbagePage);
                            }
                            garbageBuffer.setDirtyAtTimestamp(timestamp);
                        }
                        Debug.$assert0.t(buffer != null && buffer.getPageAddress() != 0L && buffer.getPageAddress() != this._garbageRoot && buffer.getPageAddress() != this._directoryRootPage);
                        this.harvestLongRecords(buffer, 0, Integer.MAX_VALUE, chains);
                        buffer.init(0);
                        buffer.clear();
                        buffer2 = buffer;
                        garbageBuffer = this.releaseBuffer(garbageBuffer);
                        if (chains.isEmpty()) break block16;
                    }
                    catch (Throwable throwable) {
                        garbageBuffer = this.releaseBuffer(garbageBuffer);
                        if (!chains.isEmpty()) {
                            this.deallocateGarbageChain(chains);
                        }
                        throw throwable;
                    }
                    this.deallocateGarbageChain(chains);
                }
                return buffer2;
            }
            finally {
                this._volume.getStorage().releaseHeadBuffer();
            }
        }
        long page = this._volume.getStorage().allocNewPage();
        buffer = this._pool.get(this._volume, page, true, false);
        buffer.init(0);
        Debug.$assert0.t(buffer.getPageAddress() != 0L);
        return buffer;
    }

    void deallocateGarbageChain(long left, long right) throws PersistitException {
        ArrayList<Chain> list = new ArrayList<Chain>();
        list.add(new Chain(left, right));
        this.deallocateGarbageChain(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deallocateGarbageChain(List<Chain> chains) throws PersistitException {
        this._volume.getStorage().claimHeadBuffer();
        try {
            while (!chains.isEmpty()) {
                Chain chain = chains.remove(chains.size() - 1);
                long left = chain.getLeft();
                long right = chain.getRight();
                assert (left > 0L || right < 0L) : "Attempt to deallocate invalid garbage chain " + chain;
                Buffer garbageBuffer = null;
                long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                try {
                    long garbagePage = this.getGarbageRoot();
                    if (garbagePage != 0L) {
                        if (left == garbagePage) {
                            throw new IllegalStateException("De-allocating page that is already garbage: root=" + garbagePage + " left=" + left + " right=" + right);
                        }
                        garbageBuffer = this._pool.get(this._volume, garbagePage, true, true);
                        garbageBuffer.writePageOnCheckpoint(timestamp);
                        boolean fits = garbageBuffer.addGarbageChain(left, right, -1L);
                        if (fits) {
                            this._persistit.getLogBase().newGarbageChain.log(left, right, this.garbageBufferInfo(garbageBuffer));
                            garbageBuffer.setDirtyAtTimestamp(timestamp);
                            continue;
                        }
                        this._persistit.getLogBase().garbagePageFull.log(left, right, this.garbageBufferInfo(garbageBuffer));
                        garbageBuffer = this.releaseBuffer(garbageBuffer);
                    }
                    garbageBuffer = this._pool.get(this._volume, left, true, true);
                    garbageBuffer.writePageOnCheckpoint(timestamp);
                    assert (garbageBuffer.isDataPage() || garbageBuffer.isIndexPage() || garbageBuffer.isLongRecordPage()) : "Attempt to allocate invalid type of page: " + garbageBuffer;
                    long nextGarbagePage = garbageBuffer.getRightSibling();
                    assert (nextGarbagePage > 0L || right == 0L) : "Attempt to deallcoate broken chain " + chain + " starting at left page " + garbageBuffer;
                    Debug.$assert0.t(nextGarbagePage > 0L || right == 0L);
                    this.harvestLongRecords(garbageBuffer, 0, Integer.MAX_VALUE, chains);
                    garbageBuffer.init(30);
                    this._persistit.getLogBase().newGarbageRoot.log(this.garbageBufferInfo(garbageBuffer));
                    if (nextGarbagePage != right) {
                        garbageBuffer.addGarbageChain(nextGarbagePage, right, -1L);
                        this._persistit.getLogBase().newGarbageChain.log(nextGarbagePage, right, this.garbageBufferInfo(garbageBuffer));
                    }
                    garbageBuffer.setRightSibling(garbagePage);
                    garbageBuffer.setDirtyAtTimestamp(timestamp);
                    this.setGarbageRoot(garbageBuffer.getPageAddress());
                }
                finally {
                    if (garbageBuffer == null) continue;
                    garbageBuffer.releaseTouched();
                }
            }
            return;
        }
        finally {
            this._volume.getStorage().releaseHeadBuffer();
        }
    }

    void harvestLongRecords(Buffer buffer, int start, int end) throws PersistitException {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        this.harvestLongRecords(buffer, start, end, chains);
        this.deallocateGarbageChain(chains);
    }

    void harvestLongRecords(Buffer buffer, int start, int end, List<Chain> chains) throws PersistitException {
        assert (buffer.isOwnedAsWriterByMe()) : "Harvesting from page owned by another thread: " + buffer;
        if (buffer.isDataPage()) {
            int p1 = buffer.toKeyBlock(start);
            int p2 = buffer.toKeyBlock(end);
            int p = p1;
            while (p < p2 && p != -1) {
                long pointer = buffer.fetchLongRecordPointer(p);
                assert (pointer != -1L) : "Long record at keyblock " + p + " was already harvested from " + buffer;
                if (pointer != 0L) {
                    chains.add(new Chain(pointer, 0L));
                    buffer.neuterLongRecord(p);
                }
                p = buffer.nextKeyBlock(p);
            }
        }
    }

    private Buffer releaseBuffer(Buffer buffer) {
        if (buffer != null) {
            buffer.releaseTouched();
        }
        return null;
    }

    public long getDirectoryRoot() {
        return this._directoryRootPage;
    }

    Tree getDirectoryTree() {
        return this._directoryTree;
    }

    public long getGarbageRoot() {
        return this._garbageRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> getGarbageList() throws PersistitException {
        ArrayList<Long> garbageList;
        block8: {
            garbageList = new ArrayList<Long>();
            this._volume.getStorage().claimHeadBuffer();
            try {
                long root = this.getGarbageRoot();
                if (root == 0L) break block8;
                garbageList.add(root);
                Buffer buffer = this._pool.get(this._volume, root, true, true);
                try {
                    for (Management.RecordInfo rec : buffer.getRecords()) {
                        if (rec._garbageLeftPage > 0L) {
                            garbageList.add(rec._garbageLeftPage);
                        }
                        if (rec._garbageRightPage <= 0L) continue;
                        garbageList.add(rec._garbageRightPage);
                    }
                }
                finally {
                    buffer.release();
                }
            }
            finally {
                this._volume.getStorage().releaseHeadBuffer();
            }
        }
        return garbageList;
    }

    private void setGarbageRoot(long garbagePage) throws PersistitException {
        this._garbageRoot = garbagePage;
        this._volume.getStorage().flushMetaData();
    }

    public int getPageSize() {
        return this._pageSize;
    }

    BufferPool getPool() {
        return this._pool;
    }

    private String garbageBufferInfo(Buffer buffer) {
        if (buffer.getPageType() != 30) {
            return "!!!" + buffer.getPageAddress() + " is not a garbage page!!!";
        }
        return "@<" + buffer.getPageAddress() + ":" + buffer.getAlloc() + ">";
    }

    synchronized boolean treeMapContainsName(String treeName) {
        return this._treeNameHashMap.containsKey(treeName);
    }

    static class Chain {
        final long _left;
        final long _right;

        private Chain(long left, long right) {
            this._left = left;
            this._right = right;
        }

        private long getLeft() {
            return this._left;
        }

        private long getRight() {
            return this._right;
        }

        public String toString() {
            return String.format("%,d->%,d", this._left, this._right);
        }
    }
}

