/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AlertMonitor;
import com.persistit.Buffer;
import com.persistit.MediatedFileChannel;
import com.persistit.Persistit;
import com.persistit.Volume;
import com.persistit.VolumeStatistics;
import com.persistit.VolumeStorage;
import com.persistit.VolumeStructure;
import com.persistit.exception.InUseException;
import com.persistit.exception.InvalidPageAddressException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.ReadOnlyVolumeException;
import com.persistit.exception.VolumeClosedException;
import com.persistit.exception.VolumeFullException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class VolumeStorageT2
extends VolumeStorage {
    static final String TEMP_FILE_PREFIX = "persistit_tempvol_";
    private final File _tempDirectory;
    private long _maxPages;
    private volatile String _path;
    private volatile FileChannel _channel;
    private volatile long _nextAvailablePage;
    private volatile boolean _opened;
    private volatile boolean _closed;

    VolumeStorageT2(Persistit persistit, Volume volume, File tempDirectory) {
        super(persistit, volume);
        this._tempDirectory = tempDirectory;
    }

    @Override
    String getPath() {
        return this._path;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    boolean isTemp() {
        return true;
    }

    @Override
    synchronized FileChannel getChannel() throws PersistitIOException {
        if (this._channel == null) {
            try {
                File file = File.createTempFile(TEMP_FILE_PREFIX, null, this._tempDirectory);
                this._path = file.getPath();
                this._channel = new MediatedFileChannel(this._path, "rw");
            }
            catch (IOException ioe) {
                this._persistit.getLogBase().tempVolumeCreateException.log(ioe, this._path);
                throw new PersistitIOException(ioe);
            }
        }
        return this._channel;
    }

    @Override
    void create() throws PersistitException {
        long maxSize = this._persistit.getConfiguration().getTmpVolMaxSize();
        this._maxPages = maxSize / (long)this._volume.getStructure().getPageSize();
        this._path = "";
        this._channel = null;
        this.truncate();
        this._opened = true;
    }

    @Override
    void open() throws PersistitException {
        throw new UnsupportedOperationException("Temporary volume can only be created.");
    }

    @Override
    boolean exists() throws PersistitException {
        return false;
    }

    @Override
    boolean delete() throws PersistitException {
        return false;
    }

    @Override
    void force() throws PersistitIOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() throws PersistitException {
        VolumeStorageT2 volumeStorageT2 = this;
        synchronized (volumeStorageT2) {
            if (this._closed) {
                return;
            }
            this._closed = true;
        }
        PersistitException pe = null;
        try {
            this.closeChannel();
        }
        catch (Exception e) {
            this._persistit.getLogBase().exception.log(e);
            pe = new PersistitException(e);
        }
        try {
            if (this._path != null) {
                File file = new File(this._path);
                file.delete();
            }
        }
        catch (Exception e) {
            this._persistit.getLogBase().exception.log(e);
            pe = new PersistitException(e);
        }
        if (pe != null) {
            throw pe;
        }
    }

    private void closeChannel() throws IOException {
        FileChannel channel = this._channel;
        this._channel = null;
        if (channel != null) {
            channel.close();
        }
    }

    @Override
    void truncate() throws PersistitException {
        if (!this.claim(true, 0L)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            this.truncateInternal();
        }
        finally {
            this.release();
        }
    }

    protected void truncateInternal() throws PersistitException {
        VolumeStatistics stat = this._volume.getStatistics();
        VolumeStructure struc = this._volume.getStructure();
        long now = System.currentTimeMillis();
        stat.setCreateTime(now);
        stat.setOpenTime(now);
        this._nextAvailablePage = 1L;
        struc.init(0L, 0L);
    }

    @Override
    boolean isOpened() {
        return this._opened;
    }

    @Override
    boolean isClosed() {
        return this._closed;
    }

    @Override
    long getExtentedPageCount() {
        return this._nextAvailablePage;
    }

    @Override
    long getNextAvailablePage() {
        return this._nextAvailablePage;
    }

    @Override
    void claimHeadBuffer() throws PersistitException {
    }

    @Override
    void releaseHeadBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void readPage(Buffer buffer) throws PersistitIOException, InvalidPageAddressException, VolumeClosedException, InUseException, PersistitInterruptedException {
        if (!this.claim(false, 0L)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            long page = buffer.getPageAddress();
            if (page < 1L || page >= this._nextAvailablePage) {
                throw new InvalidPageAddressException("Page " + page + " out of bounds [0-" + this._nextAvailablePage + "]");
            }
            try {
                int bytesRead;
                ByteBuffer bb = buffer.getByteBuffer();
                bb.position(0).limit(buffer.getBufferSize());
                for (int read = 0; read < buffer.getBufferSize(); read += bytesRead) {
                    long position = (page - 1L) * (long)this._volume.getStructure().getPageSize() + (long)bb.position();
                    bytesRead = this.getChannel().read(bb, position);
                    if (bytesRead > 0) continue;
                    throw new PersistitIOException("Unable to read bytes at position " + position + " in " + this);
                }
                this._persistit.getIOMeter().chargeReadPageFromVolume(this._volume, buffer.getPageAddress(), buffer.getBufferSize(), buffer.getIndex());
                this._volume.getStatistics().bumpReadCounter();
            }
            catch (IOException ioe) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().readException, ioe, this._volume, page, buffer.getIndex()), "ReadPage");
                throw new PersistitIOException(ioe);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    void writePage(Buffer buffer) throws PersistitIOException, InvalidPageAddressException, ReadOnlyVolumeException, VolumeClosedException, InUseException, PersistitInterruptedException {
        int pageSize = this._volume.getStructure().getPageSize();
        ByteBuffer bb = buffer.getByteBuffer();
        bb.position(0).limit(pageSize);
        this.writePage(bb, buffer.getPageAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writePage(ByteBuffer bb, long page) throws PersistitIOException, InvalidPageAddressException, ReadOnlyVolumeException, VolumeClosedException, InUseException, PersistitInterruptedException {
        int pageSize = this._volume.getStructure().getPageSize();
        if (!this.claim(false, 0L)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            if (page < 0L || page >= this._nextAvailablePage) {
                throw new InvalidPageAddressException("Page " + page + " out of bounds [0-" + this._nextAvailablePage + "]");
            }
            try {
                this.getChannel().write(bb, (page - 1L) * (long)pageSize);
            }
            catch (IOException ioe) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().writeException, ioe, this._volume, page), "WritePage");
                throw new PersistitIOException(ioe);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    synchronized long allocNewPage() throws PersistitException {
        if (this._nextAvailablePage >= this._maxPages) {
            throw new VolumeFullException(this._volume.getName());
        }
        long page = this._nextAvailablePage++;
        this._volume.getStatistics().setNextAvailablePage(page);
        return page;
    }

    @Override
    void flush() throws PersistitException {
    }

    @Override
    void flushMetaData() throws PersistitException {
    }

    @Override
    void extend(long pageAddr) throws PersistitException {
    }

    @Override
    boolean updateMetaData(byte[] bytes) {
        return false;
    }

    @Override
    public String toString() {
        return this._volume.toString();
    }
}

