/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.exception.PersistitInterruptedException;
import com.persistit.util.Util;
import java.util.concurrent.atomic.AtomicLong;

class TimestampAllocator {
    private static final int CHECKPOINT_TIMESTAMP_MARKER_INTERVAL = 100;
    private static final long UNAVAILABLE_CHECKPOINT_TIMESTAMP = -1L;
    private final AtomicLong _timestamp = new AtomicLong();
    private volatile long _checkpointTimestamp;

    TimestampAllocator() {
    }

    public long updateTimestamp() {
        return this._timestamp.incrementAndGet();
    }

    long bumpTimestamp(long delta) {
        return this._timestamp.addAndGet(delta);
    }

    public long updateTimestamp(long timestamp) {
        long expected;
        this._timestamp.incrementAndGet();
        while ((expected = this._timestamp.get()) < timestamp) {
            if (!this._timestamp.compareAndSet(expected, timestamp)) continue;
            return timestamp;
        }
        return expected;
    }

    long allocateCheckpointTimestamp() {
        long timestamp;
        this.bumpTimestamp(100L);
        this._checkpointTimestamp = -1L;
        this._checkpointTimestamp = timestamp = this.updateTimestamp();
        return timestamp;
    }

    public long getCurrentTimestamp() {
        return this._timestamp.get();
    }

    long getProposedCheckpointTimestamp() throws PersistitInterruptedException {
        long timestamp;
        int iterations = 0;
        while ((timestamp = this._checkpointTimestamp) == -1L) {
            if (iterations > 10) {
                Util.spinSleep();
            }
            ++iterations;
        }
        return timestamp;
    }
}

