/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.Persistit;
import com.persistit.Task;
import com.persistit.Tree;
import com.persistit.TreeSelector;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.VolumeSpecification;
import com.persistit.exception.CorruptImportStreamException;
import com.persistit.exception.PersistitException;
import com.persistit.policy.SplitPolicy;
import com.persistit.util.Util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class StreamLoader
extends Task {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    protected String _filePath;
    protected DataInputStream _dis;
    protected Key _key = new Key((Persistit)null);
    protected Value _value = new Value((Persistit)null);
    protected Volume _lastVolume;
    protected Tree _lastTree;
    protected int _dataRecordCount = 0;
    protected int _otherRecordCount = 0;
    protected boolean _stop;
    protected Exception _lastException;
    protected TreeSelector _treeSelector;
    protected boolean _createMissingVolumes;
    protected boolean _createMissingTrees;
    protected ImportHandler _handler;

    @CLI.Cmd(value="load")
    static Task createStreamLoader(@CLI.Arg(value="file|string:|Load from file path") String file, @CLI.Arg(value="trees|string:|Tree selector - specify Volumes/Trees/Keys to save") String treeSelectorString, @CLI.Arg(value="_flag|r|Use regular expressions in tree selector") boolean regex, @CLI.Arg(value="_flag|n|Don't create missing Volumes (Default is to create them)") boolean dontCreateVolumes, @CLI.Arg(value="_flag|t|Don't create missing Trees (Default is to create them)") boolean dontCreateTrees, @CLI.Arg(value="_flag|v|verbose") boolean verbose) throws Exception {
        StreamLoader task = new StreamLoader();
        task._filePath = file;
        task._treeSelector = TreeSelector.parseSelector(treeSelectorString, regex, '\\');
        task._createMissingVolumes = !dontCreateVolumes;
        task._createMissingTrees = !dontCreateTrees;
        task.setMessageLogVerbosity(verbose ? 1 : 0);
        return task;
    }

    StreamLoader() {
    }

    public StreamLoader(Persistit persistit, DataInputStream dis) {
        super(persistit);
        this._dis = dis;
    }

    public StreamLoader(Persistit persistit, File file) throws IOException {
        this(persistit, new DataInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public StreamLoader(Persistit persistit, String fileName) throws IOException {
        this(persistit, new DataInputStream(new BufferedInputStream(new FileInputStream(fileName))));
    }

    public void close() throws IOException {
        this._dis.close();
    }

    public void load() throws IOException, PersistitException {
        this.load(new TreeSelector(), true, true);
    }

    public void load(TreeSelector treeSelector, boolean createMissingVolumes, boolean createMissingTrees) throws IOException, PersistitException {
        this._handler = new ImportHandler(this._persistit, treeSelector, createMissingVolumes, createMissingTrees);
        this.load(this._handler);
        this.close();
    }

    public void load(ImportHandler handler) throws IOException, PersistitException {
        while (this.next(handler)) {
        }
        this.postMessage(String.format("DONE - processed %,d data records and %,d other records", this._dataRecordCount, this._otherRecordCount), 0);
    }

    public boolean next(ImportHandler handler) throws IOException, PersistitException {
        int b1 = this._dis.read();
        if (b1 == -1) {
            return false;
        }
        int b2 = this._dis.read();
        int recordType = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
        switch (recordType) {
            case 16730: {
                handler.handleFillRecord();
                ++this._otherRecordCount;
                break;
            }
            case 17490: {
                short keySize = this._dis.readShort();
                short elisionCount = this._dis.readShort();
                int valueSize = this._dis.readInt();
                this._value.ensureFit(valueSize);
                this._dis.read(this._key.getEncodedBytes(), elisionCount, keySize - elisionCount);
                this._key.setEncodedSize(keySize);
                this._dis.read(this._value.getEncodedBytes(), 0, valueSize);
                this._value.setEncodedSize(valueSize);
                handler.handleDataRecord(this._key, this._value);
                ++this._dataRecordCount;
                break;
            }
            case 19270: {
                String filterString = this._dis.readUTF();
                handler.handleKeyFilterRecord(filterString);
                ++this._otherRecordCount;
                break;
            }
            case 22089: {
                long id = this._dis.readLong();
                long initialPages = this._dis.readLong();
                long extensionPages = this._dis.readLong();
                long maximumPages = this._dis.readLong();
                int bufferSize = this._dis.readInt();
                String path = this._dis.readUTF();
                handler._volumeName = this._dis.readUTF();
                handler.handleVolumeIdRecord(id, initialPages, extensionPages, maximumPages, bufferSize, path, handler._volumeName);
                ++this._otherRecordCount;
                break;
            }
            case 21577: {
                handler._treeName = this._dis.readUTF();
                handler.handleTreeIdRecord(handler._treeName);
                ++this._otherRecordCount;
                this.postMessage("Loading Tree " + handler._treeName, 1);
                break;
            }
            case 18510: {
                String hostName = this._dis.readUTF();
                handler.handleHostNameRecord(hostName);
                ++this._otherRecordCount;
                break;
            }
            case 18517: {
                String hostName = this._dis.readUTF();
                handler.handleUserRecord(hostName);
                ++this._otherRecordCount;
                break;
            }
            case 17231: {
                String comment = this._dis.readUTF();
                handler.handleCommentRecord(comment);
                ++this._otherRecordCount;
                break;
            }
            case 21059: {
                long dataRecordCount = this._dis.readLong();
                long otherRecordCount = this._dis.readLong();
                handler.handleCountRecord(dataRecordCount, otherRecordCount);
                ++this._otherRecordCount;
                break;
            }
            case 22611: {
                handler.handleStartRecord();
                ++this._otherRecordCount;
                break;
            }
            case 22597: {
                handler.handleEndRecord();
                ++this._otherRecordCount;
                break;
            }
            case 21587: {
                long timeStamp = this._dis.readLong();
                handler.handleTimeStampRecord(timeStamp);
                ++this._otherRecordCount;
                break;
            }
            case 17752: {
                String exceptionString = this._dis.readUTF();
                handler.handleExceptionRecord(exceptionString);
                ++this._otherRecordCount;
                break;
            }
            case 23130: {
                handler.handleCompletionRecord();
                ++this._otherRecordCount;
                break;
            }
            default: {
                throw new CorruptImportStreamException("Invalid record type " + recordType + " (" + Util.bytesToHex(new byte[]{(byte)(recordType >>> 8), (byte)recordType}) + " after reading " + this._dataRecordCount + " data records and " + this._otherRecordCount + " other records");
            }
        }
        return true;
    }

    @Override
    public void runTask() throws Exception {
        this._dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this._filePath), 65536));
        this.load(this._treeSelector, this._createMissingVolumes, this._createMissingTrees);
    }

    @Override
    public String getStatus() {
        if (this._handler == null || this._handler._tree == null) {
            return null;
        }
        Tree tree = this._handler._tree;
        return tree.getName() + " in " + tree.getVolume().getPath() + " (" + this._dataRecordCount + ")";
    }

    protected static class ImportHandler {
        protected Persistit _persistit;
        protected TreeSelector _treeSelector;
        protected Exchange _exchange;
        protected Volume _volume;
        protected Tree _tree;
        protected KeyFilter _keyFilter;
        protected boolean _createMissingVolumes;
        protected boolean _createMissingTrees;
        protected String _volumeName = null;
        protected String _treeName = null;

        protected ImportHandler(Persistit persistit) {
            this(persistit, new TreeSelector(), true, true);
        }

        protected ImportHandler(Persistit persistit, TreeSelector treeSelector, boolean createMissingVolumes, boolean createMissingTrees) {
            this._persistit = persistit;
            this._treeSelector = treeSelector == null ? new TreeSelector() : treeSelector;
            this._createMissingTrees = createMissingTrees;
            this._createMissingVolumes = createMissingVolumes;
        }

        protected void handleFillRecord() throws PersistitException {
        }

        protected void handleDataRecord(Key key, Value value) throws PersistitException {
            if (this._keyFilter == null || this._keyFilter.selected(key)) {
                if (this._volume == null || this._tree == null) {
                    return;
                }
                if (this._exchange == null) {
                    this._exchange = this._persistit.getExchange(this._volume, this._tree.getName(), false);
                }
                key.copyTo(this._exchange.getKey());
                this._exchange.setSplitPolicy(SplitPolicy.PACK_BIAS);
                this._exchange.store(this._exchange.getKey(), value);
            }
        }

        protected void handleKeyFilterRecord(String keyFilterString) throws PersistitException {
        }

        protected void handleVolumeIdRecord(long volumeId, long initialPages, long extensionPages, long maximumPages, int bufferSize, String path, String name) throws PersistitException {
            Exchange oldExchange = this._exchange;
            this._exchange = null;
            this._volume = null;
            this._tree = null;
            if (!this._treeSelector.isVolumeNameSelected(name)) {
                return;
            }
            this._volume = this._persistit.getVolume(name);
            if (this._volume != null) {
                this._volume.verifyId(volumeId);
            } else if (this._createMissingVolumes) {
                this._volume = new Volume(new VolumeSpecification(path, name, bufferSize, initialPages, maximumPages, extensionPages, false, true, false));
                this._volume.setId(volumeId);
                this._volume.open(this._persistit);
            }
            if (oldExchange != null && oldExchange.getVolume().equals(this._volume)) {
                this._exchange = oldExchange;
            }
        }

        protected void handleTreeIdRecord(String treeName) throws PersistitException {
            Exchange oldExchange = this._exchange;
            this._exchange = null;
            this._tree = null;
            if (this._volume == null) {
                return;
            }
            if (!this._treeSelector.isTreeNameSelected(this._volume.getName(), treeName)) {
                return;
            }
            this._tree = this._volume.getTree(treeName, this._createMissingVolumes | this._createMissingTrees);
            if (oldExchange != null && oldExchange.getTree() == this._tree) {
                this._exchange = oldExchange;
            }
            this._keyFilter = this._treeSelector.keyFilter(this._volume.getName(), treeName);
        }

        protected void handleTimeStampRecord(long timeStamp) throws PersistitException {
        }

        protected void handleHostNameRecord(String hostName) throws PersistitException {
        }

        protected void handleUserRecord(String userName) throws PersistitException {
        }

        protected void handleCommentRecord(String comment) throws PersistitException {
        }

        protected void handleCountRecord(long keyValueRecords, long otherRecords) throws PersistitException {
        }

        protected void handleStartRecord() throws PersistitException {
        }

        protected void handleEndRecord() throws PersistitException {
        }

        protected void handleExceptionRecord(String exceptionString) throws PersistitException {
        }

        protected void handleCompletionRecord() throws PersistitException {
        }
    }
}

