/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.AlertMonitor;
import com.persistit.BufferPool;
import com.persistit.BufferPoolMXBeanImpl;
import com.persistit.CLI;
import com.persistit.CheckpointManager;
import com.persistit.ClassIndex;
import com.persistit.ClassInfo;
import com.persistit.CleanupManager;
import com.persistit.Configuration;
import com.persistit.DefaultCoderManager;
import com.persistit.Exchange;
import com.persistit.GetVersion;
import com.persistit.IOMeter;
import com.persistit.IOTaskRunnable;
import com.persistit.IntegrityCheck;
import com.persistit.JournalManager;
import com.persistit.Key;
import com.persistit.Management;
import com.persistit.ManagementImpl;
import com.persistit.RecoveryManager;
import com.persistit.SessionId;
import com.persistit.Task;
import com.persistit.TimelyResource;
import com.persistit.TimestampAllocator;
import com.persistit.Transaction;
import com.persistit.TransactionIndex;
import com.persistit.Tree;
import com.persistit.TreeSelector;
import com.persistit.Value;
import com.persistit.Version;
import com.persistit.Volume;
import com.persistit.VolumeSpecification;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.KeyCoder;
import com.persistit.encoding.ValueCoder;
import com.persistit.exception.PersistitClosedException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.TestException;
import com.persistit.exception.VolumeAlreadyExistsException;
import com.persistit.exception.VolumeNotFoundException;
import com.persistit.logging.DefaultPersistitLogger;
import com.persistit.logging.LogBase;
import com.persistit.logging.PersistitLogger;
import com.persistit.mxbeans.AlertMonitorMXBean;
import com.persistit.mxbeans.BufferPoolMXBean;
import com.persistit.mxbeans.CheckpointManagerMXBean;
import com.persistit.mxbeans.CleanupManagerMXBean;
import com.persistit.mxbeans.IOMeterMXBean;
import com.persistit.mxbeans.JournalManagerMXBean;
import com.persistit.mxbeans.MXBeanWrapper;
import com.persistit.mxbeans.ManagementMXBean;
import com.persistit.mxbeans.RecoveryManagerMXBean;
import com.persistit.mxbeans.TransactionIndexMXBean;
import com.persistit.policy.JoinPolicy;
import com.persistit.policy.SplitPolicy;
import com.persistit.util.ArgParser;
import com.persistit.util.Util;
import com.persistit.util.UtilControl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Persistit {
    public static final String VERSION = GetVersion.getVersionString() + "";
    public static final String COPYRIGHT = "Copyright (c) 2012 Akiban Technologies Inc.";
    public static final boolean BIG_ENDIAN = true;
    private static final String PERSISTIT_GUI_CLASS_NAME = "com.persistit.ui.AdminUI";
    public static final int MAX_POOLED_EXCHANGES = 10000;
    private static final int TRANSACTION_INDEX_SIZE = 256;
    static final long SHORT_DELAY = 500L;
    private static final long CLOSE_LOG_INTERVAL = 30000000000L;
    private static final int ACCUMULATOR_CHECKPOINT_THRESHOLD = 256;
    private static final SplitPolicy DEFAULT_SPLIT_POLICY = SplitPolicy.PACK_BIAS;
    private static final JoinPolicy DEFAULT_JOIN_POLICY = JoinPolicy.EVEN_BIAS;
    private static final Transaction.CommitPolicy DEFAULT_TRANSACTION_COMMIT_POLICY = Transaction.CommitPolicy.SOFT;
    private static final long DEFAULT_COMMIT_LEAD_TIME_MS = 100L;
    private static final long DEFAULT_COMMIT_STALL_TIME_MS = 1L;
    private static final long MAX_COMMIT_LEAD_TIME_MS = 5000L;
    private static final long MAX_COMMIT_STALL_TIME_MS = 5000L;
    private static final long LOG_FLUSH_DELAY_INTERVAL_MS = 5000L;
    private static final int MAX_FATAL_ERROR_MESSAGES = 10;
    private final long _availableHeap = Persistit.availableHeap();
    private volatile PersistitLogger _logger;
    private LogFlusher _logFlusher;
    private final long _startTime = System.currentTimeMillis();
    private volatile Configuration _configuration;
    private final HashMap<Integer, BufferPool> _bufferPoolTable = new HashMap();
    private final ArrayList<Volume> _volumes = new ArrayList();
    private final AtomicBoolean _initialized = new AtomicBoolean();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final AtomicBoolean _fatal = new AtomicBoolean();
    private long _beginCloseTime;
    private long _nextCloseTime;
    private final LogBase _logBase = new LogBase();
    private final AtomicBoolean _suspendShutdown = new AtomicBoolean(false);
    private final AtomicBoolean _suspendUpdates = new AtomicBoolean(false);
    private final AtomicBoolean _enableBufferInventory = new AtomicBoolean(false);
    private UtilControl _localGUI;
    private final AtomicReference<CoderManager> _coderManager = new AtomicReference();
    private final ClassIndex _classIndex = new ClassIndex(this);
    private final ThreadLocal<SessionId> _sessionIdThreadLocal = new ThreadLocal<SessionId>(){

        @Override
        protected SessionId initialValue() {
            return new SessionId();
        }
    };
    private final Map<SessionId, Transaction> _transactionSessionMap = new HashMap<SessionId, Transaction>();
    private ManagementImpl _management;
    private final RecoveryManager _recoveryManager = new RecoveryManager(this);
    private final JournalManager _journalManager = new JournalManager(this);
    private final TimestampAllocator _timestampAllocator = new TimestampAllocator();
    private final CheckpointManager _checkpointManager = new CheckpointManager(this);
    private final CleanupManager _cleanupManager = new CleanupManager(this);
    private final IOMeter _ioMeter = new IOMeter();
    private final AlertMonitor _alertMonitor = new AlertMonitor();
    private final TransactionIndex _transactionIndex = new TransactionIndex(this._timestampAllocator, 256);
    private final Map<SessionId, List<Exchange>> _exchangePoolMap = new WeakHashMap<SessionId, List<Exchange>>();
    private final Map<ObjectName, Object> _mxbeans = new TreeMap<ObjectName, Object>();
    private final List<AlertMonitorMXBean> _alertMonitors = Collections.synchronizedList(new ArrayList());
    private final Set<Accumulator.AccumulatorRef> _accumulators = new HashSet<Accumulator.AccumulatorRef>();
    private final Set<WeakReference<TimelyResource<?>>> _timelyResourceSet = new HashSet();
    private final WeakHashMap<SessionId, CLI> _cliSessionMap = new WeakHashMap();
    private boolean _readRetryEnabled;
    private volatile SplitPolicy _defaultSplitPolicy = DEFAULT_SPLIT_POLICY;
    private volatile JoinPolicy _defaultJoinPolicy = DEFAULT_JOIN_POLICY;
    private volatile List<FatalErrorException> _fatalErrors = new ArrayList<FatalErrorException>();
    private volatile Transaction.CommitPolicy _defaultCommitPolicy = DEFAULT_TRANSACTION_COMMIT_POLICY;
    private volatile long _commitLeadTime = 100L;
    private volatile long _commitStallTime = 1L;
    private final ThreadLocal<SoftReference<int[]>> _intArrayThreadLocal = new ThreadLocal();
    private final ThreadLocal<SoftReference<Key>> _keyThreadLocal = new ThreadLocal();
    private final ThreadLocal<SoftReference<Value>> _valueThreadLocal = new ThreadLocal();
    private final AtomicLong _uniqueCounter = new AtomicLong();
    private volatile Volume _lockVolume;
    private static final String[] ARG_TEMPLATE = new String[]{"_flag|g|Start AdminUI", "_flag|i|Perform IntegrityCheck on all volumes", "_flag|w|Wait until AdminUI exists", "_flag|c|Perform copy-back", "properties|string|Property file name", "cliport|int:-1:1024:99999999|Port on which to start a simple command-line interface server", "script|string|Pathname of CLI script to execute"};

    public Persistit() {
    }

    public Persistit(Configuration configuration) throws PersistitException {
        this.setConfiguration(configuration);
        this.initialize();
    }

    public Persistit(Properties properties) throws PersistitException {
        this.setProperties(properties);
        this.initialize();
    }

    public synchronized void setConfiguration(Configuration configuration) {
        if (this._configuration != null) {
            throw new IllegalStateException("Configuration has already been set");
        }
        this._configuration = configuration;
    }

    public void setPropertiesFromFile(String propertiesFileName) throws PersistitException {
        Configuration configuration = new Configuration();
        configuration.readPropertiesFile(propertiesFileName);
        this.setConfiguration(configuration);
    }

    public void setProperties(Properties properties) {
        this.setConfiguration(new Configuration(properties));
    }

    public synchronized void initialize() throws PersistitException {
        if (this.isInitialized()) {
            return;
        }
        if (this._configuration == null) {
            Configuration config = new Configuration();
            config.readPropertiesFile();
            this._configuration = config;
        }
        try {
            this._closed.set(false);
            this.initializeLogging();
            this.initializeManagement();
            this.initializeOther();
            this.initializeRecovery();
            this.initializeJournal();
            this.initializeBufferPools();
            this.initializeVolumes();
            this.startJournal();
            this.startBufferPools();
            this.preloadBufferPools();
            this.initializeClassIndex();
            this.finishRecovery();
            this.startTransactionIndexPollTask();
            this.flush();
            this._checkpointManager.checkpoint();
            this._journalManager.pruneObsoleteTransactions();
            this.startCheckpointManager();
            this.startCleanupManager();
            this._initialized.set(true);
        }
        finally {
            if (!this.isInitialized()) {
                this.releaseAllResources();
                this._configuration = null;
            }
        }
    }

    @Deprecated
    public void initialize(String propertiesFileName) throws PersistitException {
        if (!this.isInitialized()) {
            this.setPropertiesFromFile(propertiesFileName);
            this.initialize();
        }
    }

    @Deprecated
    public void initialize(Properties properties) throws PersistitException {
        if (!this.isInitialized()) {
            this.setProperties(properties);
            this.initialize();
        }
    }

    @Deprecated
    public void initialize(Configuration configuration) throws PersistitException {
        if (!this.isInitialized()) {
            this.setConfiguration(configuration);
            this.initialize();
        }
    }

    private void initializeLogging() throws PersistitException {
        try {
            this._logFlusher = new LogFlusher();
            this._logFlusher.start();
            this.getPersistitLogger().open();
            String logLevel = this._configuration.getLogging();
            if (logLevel != null && this.getPersistitLogger() instanceof DefaultPersistitLogger) {
                ((DefaultPersistitLogger)this.getPersistitLogger()).setLevel(logLevel);
            }
            this._logBase.configure(this.getPersistitLogger());
            this._logBase.start.log(this._startTime);
            this._logBase.copyright.log(Persistit.copyright());
        }
        catch (Exception e) {
            System.err.println("Persistit(tm) Logging is disabled due to " + e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                System.err.println(e.getMessage());
            }
            e.printStackTrace();
        }
    }

    private void initializeRecovery() throws PersistitException {
        String journalPath = this._configuration.getJournalPath();
        this._recoveryManager.init(journalPath);
        this._recoveryManager.buildRecoveryPlan();
    }

    void initializeJournal() throws PersistitException {
        String journalPath = this._configuration.getJournalPath();
        long journalSize = this._configuration.getJournalSize();
        this._journalManager.init(this._recoveryManager, journalPath, journalSize);
        this._journalManager.setAppendOnly(this._configuration.isAppendOnly());
        this._journalManager.setIgnoreMissingVolumes(this._configuration.isIgnoreMissingVolumes());
    }

    private void initializeBufferPools() {
        for (Configuration.BufferPoolConfiguration config : this._configuration.getBufferPoolMap().values()) {
            int poolSize = config.computeBufferCount(this.getAvailableHeap());
            if (poolSize <= 0) continue;
            int bufferSize = config.getBufferSize();
            this._logBase.allocateBuffers.log(poolSize, bufferSize);
            BufferPool pool = new BufferPool(poolSize, bufferSize, this);
            this._bufferPoolTable.put(bufferSize, pool);
            if (!this._configuration.isJmxEnabled()) continue;
            this.registerBufferPoolMXBean(bufferSize);
        }
    }

    private void initializeVolumes() throws PersistitException {
        for (VolumeSpecification volumeSpecification : this._configuration.getVolumeList()) {
            Volume volume = this._journalManager.getVolumeByName(volumeSpecification.getName());
            if (volume == null) {
                volume = new Volume(volumeSpecification);
            } else {
                volume.overwriteSpecification(volumeSpecification);
            }
            this._logBase.openVolume.log(volumeSpecification.getName(), volumeSpecification.getAbsoluteFile());
            volume.open(this);
        }
    }

    private void initializeManagement() {
        String rmiHost = this._configuration.getRmiHost();
        int rmiPort = this._configuration.getRmiPort();
        int serverPort = this._configuration.getRmiServerPort();
        boolean enableJmx = this._configuration.isJmxEnabled();
        if (rmiHost != null || rmiPort > 0) {
            ManagementImpl management = (ManagementImpl)this.getManagement();
            management.register(rmiHost, rmiPort, serverPort);
        }
        if (enableJmx) {
            this.registerMXBeans();
        }
    }

    private void initializeOther() {
        DefaultCoderManager cm = new DefaultCoderManager(this, this._configuration.getSerialOverride());
        this._coderManager.set(cm);
        if (this._configuration.isShowGUI()) {
            try {
                this.setupGUI(true);
            }
            catch (Exception e) {
                this._logBase.configurationError.log(e);
            }
        }
        this._defaultSplitPolicy = this._configuration.getSplitPolicy();
        this._defaultJoinPolicy = this._configuration.getJoinPolicy();
        this._defaultCommitPolicy = this._configuration.getCommitPolicy();
        this._enableBufferInventory.set(this._configuration.isBufferInventoryEnabled());
    }

    private void initializeClassIndex() throws PersistitException {
        this._classIndex.initialize();
    }

    void startCheckpointManager() {
        this._checkpointManager.start();
    }

    void startCleanupManager() {
        this._cleanupManager.start();
    }

    void startTransactionIndexPollTask() {
        this._transactionIndex.start(this);
    }

    void startBufferPools() throws PersistitException {
        for (BufferPool pool : this._bufferPoolTable.values()) {
            pool.startThreads();
        }
    }

    void recordBufferPoolInventory() {
        long timestamp = this._timestampAllocator.getCurrentTimestamp();
        if (this._enableBufferInventory.get()) {
            for (BufferPool pool : this._bufferPoolTable.values()) {
                try {
                    pool.recordBufferInventory(timestamp);
                }
                catch (PersistitException e) {
                    this.getLogBase().bufferInventoryException.log(e);
                }
            }
        }
    }

    void preloadBufferPools() throws PersistitException {
        if (this._configuration.isBufferPreloadEnabled()) {
            for (BufferPool pool : this._bufferPoolTable.values()) {
                pool.preloadBufferInventory();
            }
        }
    }

    void startJournal() throws PersistitException {
        this._journalManager.startJournal();
    }

    void finishRecovery() throws PersistitException, TestException {
        this._recoveryManager.applyAllRecoveredTransactions(this._recoveryManager.getDefaultCommitListener(), this._recoveryManager.getDefaultRollbackListener());
        this._recoveryManager.close();
        this.flush();
        this._logBase.recoveryDone.log(this._journalManager.getPageMapSize(), this._recoveryManager.getAppliedTransactionCount(), this._recoveryManager.getErrorCount());
    }

    private void registerMXBeans() {
        try {
            this.registerMBean(this.getManagement(), ManagementMXBean.class, "com.persistit:type=Persistit");
            this.registerMBean(this._ioMeter, IOMeterMXBean.class, "com.persistit:type=Persistit,class=IOMeter");
            this.registerMBean(this._checkpointManager, CheckpointManagerMXBean.class, "com.persistit:type=Persistit,class=CheckpointManager");
            this.registerMBean(this._cleanupManager, CleanupManagerMXBean.class, "com.persistit:type=Persistit,class=CleanupManager");
            this.registerMBean(this._transactionIndex, TransactionIndexMXBean.class, "com.persistit:type=Persistit,class=TransactionIndex");
            this.registerMBean(this._journalManager, JournalManagerMXBean.class, "com.persistit:type=Persistit,class=JournalManager");
            this.registerMBean(this._recoveryManager, RecoveryManagerMXBean.class, "com.persistit:type=Persistit,class=RecoveryManager");
            this.registerMBean(this._alertMonitor, AlertMonitorMXBean.class, "com.persistit:type=Persistit,class=AlertMonitor");
        }
        catch (Exception exception) {
            this._logBase.mbeanException.log(exception);
        }
    }

    private void registerBufferPoolMXBean(int bufferSize) {
        try {
            BufferPoolMXBeanImpl bean = new BufferPoolMXBeanImpl(this, bufferSize);
            this.registerMBean(bean, BufferPoolMXBean.class, BufferPoolMXBeanImpl.mbeanName(bufferSize));
        }
        catch (Exception exception) {
            this._logBase.mbeanException.log(exception);
        }
    }

    private void registerMBean(Object mbean, Class<?> mbeanInterface, String name) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName on = new ObjectName(name);
        AlertMonitor emitter = null;
        if (mbean instanceof AlertMonitor) {
            AlertMonitor monitor = (AlertMonitor)mbean;
            monitor.setObjectName(on);
            emitter = monitor;
        }
        MXBeanWrapper<Object> wrapper = new MXBeanWrapper<Object>(mbean, mbeanInterface, emitter);
        server.registerMBean(wrapper, on);
        this._logBase.mbeanRegistered.log(on);
        this._mxbeans.put(on, mbean);
        if (mbean instanceof AlertMonitorMXBean) {
            this._alertMonitors.add((AlertMonitorMXBean)mbean);
        }
    }

    Map<ObjectName, Object> getMXBeans() {
        return Collections.unmodifiableMap(this._mxbeans);
    }

    private void unregisterMXBeans() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName on : this._mxbeans.keySet()) {
            try {
                server.unregisterMBean(on);
                this._logBase.mbeanUnregistered.log(on);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (Exception exception) {
                this._logBase.mbeanException.log(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addVolume(Volume volume) throws VolumeAlreadyExistsException {
        ArrayList<Volume> arrayList = this._volumes;
        synchronized (arrayList) {
            Volume otherVolume = this.getVolume(volume.getName());
            if (otherVolume != null) {
                throw new VolumeAlreadyExistsException("Volume " + otherVolume);
            }
            this._volumes.add(volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeVolume(Volume volume) throws PersistitInterruptedException {
        ArrayList<Volume> arrayList = this._volumes;
        synchronized (arrayList) {
            this._volumes.remove(volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange getExchange(Volume volume, String treeName, boolean create) throws PersistitException {
        List<Exchange> stack;
        if (volume == null) {
            throw new VolumeNotFoundException();
        }
        SessionId sessionId = this.getSessionId();
        Map<SessionId, List<Exchange>> map = this._exchangePoolMap;
        synchronized (map) {
            stack = this._exchangePoolMap.get(sessionId);
            if (stack == null) {
                stack = new ArrayList<Exchange>();
                this._exchangePoolMap.put(sessionId, stack);
            }
        }
        if (stack.isEmpty()) {
            return new Exchange(this, volume, treeName, create);
        }
        Exchange exchange = stack.remove(stack.size() - 1);
        exchange.init(volume, treeName, create);
        return exchange;
    }

    public Exchange getExchange(String volumeName, String treeName, boolean create) throws PersistitException {
        Volume volume = this.getVolume(volumeName);
        if (volume == null) {
            throw new VolumeNotFoundException(volumeName);
        }
        return this.getExchange(volume, treeName, create);
    }

    public void releaseExchange(Exchange exchange) {
        this.releaseExchange(exchange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExchange(Exchange exchange, boolean secure) {
        List<Exchange> stack;
        if (exchange == null) {
            return;
        }
        SessionId sessionId = this.getSessionId();
        Map<SessionId, List<Exchange>> map = this._exchangePoolMap;
        synchronized (map) {
            stack = this._exchangePoolMap.get(sessionId);
            if (stack == null) {
                throw new IllegalStateException("Release not preceded by get");
            }
        }
        if (stack.size() < 10000) {
            exchange.removeState(secure);
            stack.add(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Volume> getVolumes() {
        ArrayList<Volume> arrayList = this._volumes;
        synchronized (arrayList) {
            return new ArrayList<Volume>(this._volumes);
        }
    }

    public List<Tree> getSelectedTrees(TreeSelector selector) throws PersistitException {
        ArrayList<Tree> list = new ArrayList<Tree>();
        List<Volume> volumes = this.getVolumes();
        for (Volume volume : volumes) {
            if (!selector.isSelected(volume)) continue;
            if (selector.isVolumeOnlySelection(volume.getName())) {
                list.add(volume.getDirectoryTree());
                continue;
            }
            for (String treeName : volume.getTreeNames()) {
                if (!selector.isTreeNameSelected(volume.getName(), treeName)) continue;
                list.add(volume.getTree(treeName, false));
            }
        }
        return list;
    }

    public Volume loadVolume(String vstring) throws PersistitException {
        VolumeSpecification volumeSpec = this._configuration.volumeSpecification(vstring);
        return this.loadVolume(volumeSpec);
    }

    public Volume loadVolume(VolumeSpecification volumeSpec) throws PersistitException {
        Volume volume = this.getVolume(volumeSpec.getName());
        if (volume == null) {
            volume = new Volume(volumeSpec);
            volume.open(this);
        }
        return volume;
    }

    public Volume createTemporaryVolume() throws PersistitException {
        return this.createTemporaryVolume(this.temporaryVolumePageSize());
    }

    public Volume createTemporaryVolume(int pageSize) throws PersistitException {
        if (!Volume.isValidPageSize(pageSize)) {
            throw new IllegalArgumentException("Invalid page size " + pageSize);
        }
        String directoryName = this.getConfiguration().getTmpVolDir();
        File directory = directoryName == null ? null : new File(directoryName);
        return Volume.createTemporaryVolume(this, pageSize, directory);
    }

    private int temporaryVolumePageSize() {
        int pageSize = this._configuration.getTmpVolPageSize();
        if (pageSize == 0) {
            for (int size : this._bufferPoolTable.keySet()) {
                if (size <= pageSize) continue;
                pageSize = size;
            }
        }
        return pageSize;
    }

    public boolean deleteVolume(String volumeName) throws PersistitException {
        Volume volume = this.getVolume(volumeName);
        if (volume == null) {
            return false;
        }
        volume.closing();
        volume.close();
        return volume.delete();
    }

    public synchronized Management getManagement() {
        if (this._management == null) {
            this._management = new ManagementImpl(this);
        }
        return this._management;
    }

    public static String copyright() {
        return COPYRIGHT;
    }

    public static String version() {
        return VERSION;
    }

    public long startTime() {
        return this._startTime;
    }

    public long elapsedTime() {
        return System.currentTimeMillis() - this._startTime;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    @Deprecated
    public Properties getProperties() {
        return this.getConfiguration().getProperties();
    }

    @Deprecated
    public String getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    @Deprecated
    public String substituteProperties(String text, Properties properties) {
        return this.getConfiguration().substituteProperties(text, properties);
    }

    public Volume getVolume(String name) {
        if (name == null) {
            throw new NullPointerException("Null volume name");
        }
        List<Volume> volumes = this.getVolumes();
        Volume result = null;
        for (int i = 0; i < volumes.size(); ++i) {
            Volume vol = volumes.get(i);
            if (!name.equals(vol.getName())) continue;
            if (result == null) {
                result = vol;
                continue;
            }
            return null;
        }
        if (result != null) {
            return result;
        }
        File file = new File(name).getAbsoluteFile();
        for (int i = 0; i < volumes.size(); ++i) {
            Volume vol = volumes.get(i);
            if (!file.equals(vol.getAbsoluteFile())) continue;
            if (result == null) {
                result = vol;
                continue;
            }
            return null;
        }
        return result;
    }

    public Volume getSystemVolume() throws VolumeNotFoundException {
        return this.getSpecialVolume("sysvolume", "_system");
    }

    public synchronized Volume getLockVolume() throws PersistitException {
        this.checkInitialized();
        this.checkClosed();
        if (this._lockVolume == null) {
            int pageSize = this.temporaryVolumePageSize();
            if (!Volume.isValidPageSize(pageSize)) {
                throw new IllegalArgumentException("Invalid page size " + pageSize);
            }
            String directoryName = this.getConfiguration().getTmpVolDir();
            File directory = directoryName == null ? null : new File(directoryName);
            this._lockVolume = Volume.createLockVolume(this, pageSize, directory);
            this._volumes.add(this._lockVolume);
        }
        return this._lockVolume;
    }

    public SplitPolicy getDefaultSplitPolicy() {
        return this._defaultSplitPolicy;
    }

    public JoinPolicy getDefaultJoinPolicy() {
        return this._defaultJoinPolicy;
    }

    public void setDefaultSplitPolicy(SplitPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Default SplitPolicy may not be null");
        }
        this._defaultSplitPolicy = policy;
    }

    public void setDefaultJoinPolicy(JoinPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Default JoinPolicy may not be null");
        }
        this._defaultJoinPolicy = policy;
    }

    public boolean isInitialized() {
        return this._initialized.get();
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    public boolean isReadRetryEnabled() {
        return this._readRetryEnabled;
    }

    public CheckpointManager.Checkpoint getCurrentCheckpoint() {
        return this._checkpointManager.getCurrentCheckpoint();
    }

    public CheckpointManager.Checkpoint checkpoint() throws PersistitException {
        if (this._closed.get() || !this._initialized.get()) {
            return null;
        }
        this.cleanup();
        this._journalManager.pruneObsoleteTransactions();
        CheckpointManager.Checkpoint result = this._checkpointManager.checkpoint();
        this._journalManager.pruneObsoleteTransactions();
        return result;
    }

    final long earliestLiveTransaction() {
        return this._transactionIndex.getActiveTransactionFloor();
    }

    final long earliestDirtyTimestamp() {
        long earliest = Long.MAX_VALUE;
        for (BufferPool pool : this._bufferPoolTable.values()) {
            earliest = Math.min(earliest, pool.getEarliestDirtyTimestamp());
        }
        return earliest;
    }

    public void copyBackPages() throws Exception {
        for (int i = 0; i < 5; ++i) {
            if (!this._closed.get() && this._initialized.get()) {
                this._transactionIndex.updateActiveTransactionCache();
                this._journalManager.pruneObsoleteTransactions();
                this._checkpointManager.checkpoint();
                this._journalManager.copyBack();
                int fileCount = this._journalManager.getJournalFileCount();
                long size = this._journalManager.getCurrentJournalSize();
                if (fileCount != 1 || size >= 0x400000L) continue;
                break;
            }
            throw new PersistitClosedException();
        }
    }

    public boolean isFatal() {
        return this._fatal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Volume getSpecialVolume(String propName, String dflt) throws VolumeNotFoundException {
        String volumeName = this._configuration.getSysVolume();
        ArrayList<Volume> arrayList = this._volumes;
        synchronized (arrayList) {
            if (this._volumes.size() == 1 && volumeName.equals(dflt)) {
                return this._volumes.get(0);
            }
        }
        Volume volume = this.getVolume(volumeName);
        if (volume == null) {
            throw new VolumeNotFoundException(volumeName);
        }
        return volume;
    }

    BufferPool getBufferPool(int size) {
        return this._bufferPoolTable.get(new Integer(size));
    }

    HashMap<Integer, BufferPool> getBufferPoolHashMap() {
        return this._bufferPoolTable;
    }

    void cleanup() {
        this.closeZombieTransactions(false);
        this._transactionIndex.updateActiveTransactionCache();
        this.pruneTimelyResources();
    }

    public String transactionReport(int max) {
        long[] timestamps = this._transactionIndex.oldestTransactions(max);
        if (timestamps == null) {
            return "Unstable after 10 retries";
        }
        if (timestamps.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < timestamps.length; ++index) {
            boolean found = false;
            for (Transaction txn : this._transactionSessionMap.values()) {
                if (!txn.isActive() || txn.getStartTimestamp() != timestamps[index]) continue;
                sb.append(txn.toString());
                found = true;
            }
            if (!found) {
                sb.append(String.format("No active transaction starting at %,d remains active", timestamps[index]));
            }
            sb.append(Util.NEW_LINE);
        }
        return sb.toString();
    }

    public void close() throws PersistitException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) throws PersistitException {
        if (this._initialized.get() && !this._closed.get()) {
            ArrayList<Volume> volumes;
            Persistit persistit = this;
            synchronized (persistit) {
                while (this._suspendShutdown.get()) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        throw new PersistitInterruptedException(ie);
                    }
                }
            }
            this.recordBufferPoolInventory();
            this._cleanupManager.close(flush);
            this.waitForIOTaskStop(this._cleanupManager);
            this.getTransaction().close();
            this.cleanup();
            if (this._lockVolume != null) {
                this._lockVolume.close();
            }
            Iterator<BufferPool> ie = this;
            synchronized (ie) {
                volumes = new ArrayList<Volume>(this._volumes);
            }
            if (flush) {
                for (Volume volume : volumes) {
                    volume.getStorage().flush();
                }
            }
            this._checkpointManager.close(flush);
            this.waitForIOTaskStop(this._checkpointManager);
            this._closed.set(true);
            for (BufferPool pool : this._bufferPoolTable.values()) {
                pool.close();
            }
            this._journalManager.close();
            TransactionIndex.ActiveTransactionCachePollTask task = this._transactionIndex.close();
            this.waitForIOTaskStop(task);
            this.interruptActiveThreads(500L);
            this.closeZombieTransactions(true);
            for (Volume volume : volumes) {
                volume.close();
            }
            if (flush) {
                for (BufferPool pool : this._bufferPoolTable.values()) {
                    int count = pool.getDirtyPageCount();
                    if (count <= 0) continue;
                    this._logBase.strandedPages.log(pool, count);
                }
            }
            this.pollAlertMonitors(true);
        }
        this.releaseAllResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZombieTransactions(boolean removeAllSessions) {
        HashSet<SessionId> sessionIds;
        Map<SessionId, Transaction> map = this._transactionSessionMap;
        synchronized (map) {
            sessionIds = new HashSet<SessionId>(this._transactionSessionMap.keySet());
        }
        for (SessionId sessionId : sessionIds) {
            if (sessionId.isAlive() && !removeAllSessions) continue;
            Transaction transaction = null;
            Map<SessionId, Transaction> map2 = this._transactionSessionMap;
            synchronized (map2) {
                transaction = this._transactionSessionMap.remove(sessionId);
            }
            if (transaction == null) continue;
            try {
                transaction.close();
            }
            catch (Exception e) {
                this._logBase.exception.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptActiveThreads(long timeout) throws PersistitInterruptedException {
        long expires = System.currentTimeMillis() + timeout;
        boolean remaining = false;
        do {
            HashMap<SessionId, Transaction> copy;
            Map<SessionId, Transaction> map = this._transactionSessionMap;
            synchronized (map) {
                copy = new HashMap<SessionId, Transaction>(this._transactionSessionMap);
            }
            for (Map.Entry entry : copy.entrySet()) {
                SessionId sessionId = (SessionId)entry.getKey();
                Transaction txn = (Transaction)entry.getValue();
                if (!sessionId.isAlive() || !txn.isActive()) continue;
                if (sessionId.interrupt()) {
                    this._logBase.interruptedAtClose.log(sessionId.ownerName());
                }
                remaining = true;
            }
            if (!remaining) continue;
            Util.spinSleep();
        } while (remaining && System.currentTimeMillis() < expires);
    }

    public void crash() {
        JournalManager journalManager = this._journalManager;
        if (journalManager != null) {
            try {
                journalManager.crash();
            }
            catch (IOException e) {
                this._logBase.exception.log(e);
            }
        }
        List<Volume> volumes = this.getVolumes();
        for (Volume volume : volumes) {
            try {
                volume.getStorage().close();
            }
            catch (PersistitException persistitException) {}
        }
        HashMap<Integer, BufferPool> buffers = this._bufferPoolTable;
        if (buffers != null) {
            for (BufferPool pool : buffers.values()) {
                pool.crash();
            }
        }
        this._transactionIndex.crash();
        this._cleanupManager.crash();
        this._checkpointManager.crash();
        this._closed.set(true);
        this.releaseAllResources();
        this.shutdownGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fatal(String msg, Throwable cause) {
        FatalErrorException exception = new FatalErrorException(msg, cause);
        List<FatalErrorException> list = this._fatalErrors;
        synchronized (list) {
            if (this._fatalErrors.size() < 10) {
                this._fatalErrors.add(exception);
            }
        }
        this._fatal.set(true);
        this._closed.set(true);
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllResources() {
        this.unregisterMXBeans();
        try {
            if (this._logger != null) {
                this._logBase.end.log(System.currentTimeMillis());
                this._logger.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._management != null) {
            this._management.unregister();
            this._management = null;
        }
        if (this._logFlusher != null) {
            this._logFlusher.interrupt();
        }
        this._logFlusher = null;
        Object object = this._accumulators;
        synchronized (object) {
            this._accumulators.clear();
        }
        object = this._volumes;
        synchronized (object) {
            this._volumes.clear();
        }
        object = this;
        synchronized (object) {
            this._alertMonitors.clear();
            this._bufferPoolTable.clear();
            this._intArrayThreadLocal.set(null);
            this._keyThreadLocal.set(null);
            this._valueThreadLocal.set(null);
            this._initialized.set(false);
            this._sessionIdThreadLocal.remove();
            this._cleanupManager.clear();
            this._configuration = null;
        }
        object = this._exchangePoolMap;
        synchronized (object) {
            this._exchangePoolMap.clear();
        }
        object = this._transactionSessionMap;
        synchronized (object) {
            this._transactionSessionMap.clear();
        }
        object = this._cliSessionMap;
        synchronized (object) {
            this._cliSessionMap.clear();
        }
        object = this._fatalErrors;
        synchronized (object) {
            this._fatalErrors.clear();
        }
    }

    public boolean flush() throws PersistitException {
        if (this._closed.get() || !this._initialized.get()) {
            return false;
        }
        List<Volume> volumes = this.getVolumes();
        for (Volume volume : volumes) {
            volume.getStorage().flush();
            volume.getStorage().force();
        }
        this.flushBuffers(this._timestampAllocator.getCurrentTimestamp());
        this._journalManager.force();
        return true;
    }

    void flushBuffers(long timestamp) throws PersistitInterruptedException {
        for (BufferPool pool : this._bufferPoolTable.values()) {
            pool.flush(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushTransactions(long checkpointTimestamp) throws PersistitException {
        ArrayList<Transaction> transactions;
        Map<SessionId, Transaction> map = this._transactionSessionMap;
        synchronized (map) {
            transactions = new ArrayList<Transaction>(this._transactionSessionMap.values());
        }
        for (Transaction transaction : transactions) {
            transaction.flushOnCheckpoint(checkpointTimestamp);
        }
    }

    void flushStatistics() throws PersistitException {
        List<Volume> volumes = this.getVolumes();
        for (Volume volume : volumes) {
            volume.getStructure().flushStatistics();
        }
    }

    void waitForIOTaskStop(IOTaskRunnable task) {
        if (this._beginCloseTime == 0L) {
            this._beginCloseTime = System.nanoTime();
            this._nextCloseTime = this._beginCloseTime + 30000000000L;
        }
        task.kick();
        while (!task.isStopped()) {
            try {
                task.join(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
            long now = System.currentTimeMillis();
            if (now <= this._nextCloseTime) continue;
            this._logBase.waitForClose.log((this._nextCloseTime - this._beginCloseTime) / 1000000000L);
            this._nextCloseTime += 30000000000L;
        }
    }

    public void force() throws PersistitException {
        if (this._closed.get() || !this._initialized.get()) {
            return;
        }
        List<Volume> volumes = this.getVolumes();
        for (int index = 0; index < volumes.size(); ++index) {
            Volume volume = volumes.get(index);
            if (volume.getStorage().isReadOnly()) continue;
            volume.getStorage().force();
        }
        this._journalManager.force();
    }

    void checkInitialized() throws PersistitClosedException, PersistitInterruptedException {
        if (!this.isInitialized()) {
            throw new PersistitClosedException();
        }
    }

    void checkClosed() throws PersistitClosedException, PersistitInterruptedException {
        if (this.isClosed()) {
            this.checkFatal();
            throw new PersistitClosedException();
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new PersistitInterruptedException(new InterruptedException());
        }
    }

    void checkFatal() throws FatalErrorException {
        if (this.isFatal()) {
            throw this._fatalErrors.get(0);
        }
    }

    public void checkSuspended() throws PersistitInterruptedException {
        while (this.isUpdateSuspended()) {
            Util.sleep(500L);
        }
    }

    public SessionId getSessionId() {
        return this._sessionIdThreadLocal.get();
    }

    public void setSessionId(SessionId sessionId) {
        sessionId.assign();
        this._sessionIdThreadLocal.set(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws PersistitException {
        SessionId sessionId = this._sessionIdThreadLocal.get();
        if (sessionId != null) {
            Transaction txn;
            Map<SessionId, Transaction> map = this._transactionSessionMap;
            synchronized (map) {
                txn = this._transactionSessionMap.remove(sessionId);
            }
            if (txn != null) {
                txn.close();
            }
        }
        this._sessionIdThreadLocal.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() {
        SessionId sessionId = this.getSessionId();
        Map<SessionId, Transaction> map = this._transactionSessionMap;
        synchronized (map) {
            Transaction txn = this._transactionSessionMap.get(sessionId);
            if (txn == null) {
                txn = new Transaction(this, sessionId);
                this._transactionSessionMap.put(sessionId, txn);
            }
            return txn;
        }
    }

    public Transaction.CommitPolicy getDefaultTransactionCommitPolicy() {
        return this._defaultCommitPolicy;
    }

    public void setDefaultTransactionCommitPolicy(Transaction.CommitPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("CommitPolicy may not be null");
        }
        this._defaultCommitPolicy = policy;
    }

    public void setDefaultTransactionCommitPolicy(String policyName) {
        try {
            Transaction.CommitPolicy policy = Transaction.CommitPolicy.valueOf(policyName.toUpperCase());
            this.setDefaultTransactionCommitPolicy(policy);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid CommitPolicy name: " + policyName);
        }
    }

    long getTransactionCommitLeadTime() {
        return this._commitLeadTime;
    }

    void setTransactionCommitleadTime(long time) {
        this._commitLeadTime = Util.rangeCheck(time, 0L, 5000L);
    }

    long getTransactionCommitStallTime() {
        return this._commitStallTime;
    }

    void setTransactionCommitStallTime(long time) {
        this._commitStallTime = Util.rangeCheck(time, 0L, 5000L);
    }

    void populateTransactionList(List<Transaction> transactions) {
        transactions.clear();
        for (Map.Entry<SessionId, Transaction> entry : this._transactionSessionMap.entrySet()) {
            SessionId session = entry.getKey();
            Transaction txn = entry.getValue();
            if (!session.isAlive()) continue;
            transactions.add(txn);
        }
    }

    public long getCurrentTimestamp() {
        return this._timestampAllocator.getCurrentTimestamp();
    }

    public Object getPersistitGuiContainer() {
        return this._localGUI;
    }

    public void setCoderManager(CoderManager coderManager) {
        this._coderManager.set(coderManager);
    }

    public CoderManager getCoderManager() {
        return this._coderManager.get();
    }

    public LogBase getLogBase() {
        return this._logBase;
    }

    public long getAvailableHeap() {
        return this._availableHeap;
    }

    ClassIndex getClassIndex() {
        return this._classIndex;
    }

    Class<?> classForHandle(int handle) {
        ClassInfo ci = this._classIndex.lookupByHandle(handle);
        if (ci == null) {
            return null;
        }
        return ci.getDescribedClass();
    }

    KeyCoder lookupKeyCoder(Class<?> cl) {
        CoderManager cm = this._coderManager.get();
        if (cm == null) {
            return null;
        }
        return cm.lookupKeyCoder(cl);
    }

    ValueCoder lookupValueCoder(Class<?> cl) {
        CoderManager cm = this._coderManager.get();
        if (cm == null) {
            return null;
        }
        return cm.lookupValueCoder(cl);
    }

    public RecoveryManager getRecoveryManager() {
        return this._recoveryManager;
    }

    public JournalManager getJournalManager() {
        return this._journalManager;
    }

    TimestampAllocator getTimestampAllocator() {
        return this._timestampAllocator;
    }

    CheckpointManager getCheckpointManager() {
        return this._checkpointManager;
    }

    CleanupManager getCleanupManager() {
        return this._cleanupManager;
    }

    IOMeter getIOMeter() {
        return this._ioMeter;
    }

    public AlertMonitor getAlertMonitor() {
        return this._alertMonitor;
    }

    TransactionIndex getTransactionIndex() {
        return this._transactionIndex;
    }

    public void setPersistitLogger(PersistitLogger logger) {
        this._logger = logger;
    }

    public PersistitLogger getPersistitLogger() {
        if (this._logger == null) {
            this._logger = new DefaultPersistitLogger(this._configuration.getLogFile());
        }
        return this._logger;
    }

    void pollAlertMonitors(boolean force) {
        for (AlertMonitorMXBean monitor : this._alertMonitors) {
            try {
                monitor.poll(force);
            }
            catch (Exception e) {
                this._logBase.exception.log(e);
            }
        }
    }

    public void checkAllVolumes() throws PersistitException {
        IntegrityCheck icheck = new IntegrityCheck(this);
        List<Volume> volumes = this.getVolumes();
        for (int index = 0; index < volumes.size(); ++index) {
            Volume volume = volumes.get(index);
            System.out.println("Checking " + volume + " ");
            try {
                icheck.checkVolume(volume);
                continue;
            }
            catch (Exception e) {
                System.out.println(e + " while performing IntegrityCheck on " + volume);
            }
        }
        System.out.println("  " + icheck.toString(true));
    }

    static long availableHeap() {
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long available = mu.getMax();
        if (available == -1L) {
            available = mu.getInit();
        }
        return available;
    }

    public void setupGUI(boolean suspendShutdown) throws IllegalAccessException, InstantiationException, ClassNotFoundException, RemoteException {
        if (this._localGUI == null) {
            this._logBase.startAdminUI.log(new Object[0]);
            this._localGUI = (UtilControl)Class.forName(PERSISTIT_GUI_CLASS_NAME).newInstance();
        }
        this._localGUI.setManagement(this.getManagement());
        this._suspendShutdown.set(suspendShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownGUI() {
        UtilControl localGUI;
        Persistit persistit = this;
        synchronized (persistit) {
            localGUI = this._localGUI;
            this._suspendShutdown.set(false);
            this._localGUI = null;
        }
        if (localGUI != null) {
            localGUI.close();
        }
    }

    public boolean isShutdownSuspended() {
        return this._suspendShutdown.get();
    }

    public void setShutdownSuspended(boolean suspended) {
        this._suspendShutdown.set(suspended);
    }

    public boolean isUpdateSuspended() {
        return this._suspendUpdates.get();
    }

    public void setUpdateSuspended(boolean suspended) {
        this._suspendUpdates.set(suspended);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimelyResource(TimelyResource<? extends Version> resource) {
        Set<WeakReference<TimelyResource<?>>> set = this._timelyResourceSet;
        synchronized (set) {
            this._timelyResourceSet.add(new WeakReference<TimelyResource<? extends Version>>(resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAccumulator(Accumulator accumulator) throws PersistitException {
        int checkpointCount = 0;
        Set<Accumulator.AccumulatorRef> set = this._accumulators;
        synchronized (set) {
            this._accumulators.add(accumulator.getAccumulatorRef());
            for (Accumulator.AccumulatorRef ref : this._accumulators) {
                if (ref._checkpointRef == null) continue;
                ++checkpointCount;
            }
        }
        if (checkpointCount > 0 && checkpointCount % 256 == 0) {
            try {
                this._checkpointManager.createCheckpoint();
            }
            catch (PersistitException e) {
                this._logBase.exception.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAccumulator(Accumulator accumulator) {
        Set<Accumulator.AccumulatorRef> set = this._accumulators;
        synchronized (set) {
            this._accumulators.remove(accumulator.getAccumulatorRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Accumulator> takeCheckpointAccumulators(long timestamp) {
        ArrayList<Accumulator> result = new ArrayList<Accumulator>();
        Set<Accumulator.AccumulatorRef> set = this._accumulators;
        synchronized (set) {
            Iterator<Accumulator.AccumulatorRef> refIterator = this._accumulators.iterator();
            while (refIterator.hasNext()) {
                Accumulator acc;
                Accumulator.AccumulatorRef ref = refIterator.next();
                if (!ref.isLive()) {
                    refIterator.remove();
                }
                if ((acc = ref.takeCheckpointRef(timestamp)) == null) continue;
                result.add(acc);
            }
            Collections.sort(result, Accumulator.SORT_COMPARATOR);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pruneTimelyResources() {
        ArrayList<TimelyResource> resourcesToPrune = new ArrayList<TimelyResource>();
        Set<WeakReference<TimelyResource<?>>> set = this._timelyResourceSet;
        synchronized (set) {
            for (WeakReference<TimelyResource<?>> ref : this._timelyResourceSet) {
                TimelyResource resource = (TimelyResource)ref.get();
                if (resource == null) continue;
                resourcesToPrune.add(resource);
            }
        }
        for (TimelyResource resource : resourcesToPrune) {
            try {
                resource.prune();
            }
            catch (PersistitException e) {
                this._logBase.timelyResourcePruneException.log(e, resource);
            }
        }
        set = this._timelyResourceSet;
        synchronized (set) {
            Iterator<WeakReference<TimelyResource<?>>> iter = this._timelyResourceSet.iterator();
            while (iter.hasNext()) {
                WeakReference<TimelyResource<?>> ref;
                ref = iter.next();
                if (ref.get() != null) continue;
                iter.remove();
            }
        }
    }

    synchronized CLI getSessionCLI() {
        CLI cli = this._cliSessionMap.get(this.getSessionId());
        if (cli == null) {
            cli = new CLI(this);
            this._cliSessionMap.put(this.getSessionId(), cli);
        }
        return cli;
    }

    synchronized void clearSessionCLI() {
        this._cliSessionMap.remove(this.getSessionId());
    }

    int[] getThreadLocalIntArray(int size) {
        int[] ints;
        SoftReference<int[]> ref = this._intArrayThreadLocal.get();
        if (ref != null && (ints = ref.get()) != null && ints.length >= size) {
            return ints;
        }
        ints = new int[size];
        this._intArrayThreadLocal.set(new SoftReference<int[]>(ints));
        return ints;
    }

    Key getThreadLocalKey() {
        Key key;
        SoftReference<Key> ref = this._keyThreadLocal.get();
        if (ref != null && (key = ref.get()) != null) {
            return key;
        }
        key = new Key(this);
        this._keyThreadLocal.set(new SoftReference<Key>(key));
        return key;
    }

    Value getThreadLocalValue() {
        Value value;
        SoftReference<Value> ref = this._valueThreadLocal.get();
        if (ref != null && (value = ref.get()) != null) {
            return value;
        }
        value = new Value(this);
        this._valueThreadLocal.set(new SoftReference<Value>(value));
        return value;
    }

    long unique() {
        return this._uniqueCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgParser ap = new ArgParser("Persistit", args, ARG_TEMPLATE).strict();
        if (ap.isUsageOnly()) {
            return;
        }
        Persistit persistit = null;
        String propertiesFileName = ap.getStringValue("properties");
        if (!propertiesFileName.isEmpty()) {
            persistit = new Persistit();
            persistit.setPropertiesFromFile(propertiesFileName);
            persistit.initialize();
        }
        String scriptName = ap.getStringValue("script");
        int cliport = ap.getIntValue("cliport");
        if (cliport > -1 && !propertiesFileName.isEmpty()) {
            throw new IllegalArgumentException("Specify only one: properties or cliport");
        }
        if (cliport > 1) {
            System.out.printf("Starting a Persistit CLI server on port %d\n", cliport);
            Task task = CLI.cliserver(cliport);
            task.runTask();
            task.setPersistit(persistit);
        } else if (!scriptName.isEmpty()) {
            BufferedReader reader = new BufferedReader(new FileReader(scriptName));
            PrintWriter writer = new PrintWriter(System.out);
            CLI.runScript(persistit, reader, writer);
        } else {
            if (persistit == null) {
                throw new IllegalArgumentException("Must specify a properties file");
            }
            boolean gui = ap.isFlag(103);
            boolean icheck = ap.isFlag(105);
            boolean wait = ap.isFlag(119);
            boolean copy = ap.isFlag(99);
            try {
                if (gui) {
                    persistit.setupGUI(wait);
                }
                if (icheck) {
                    persistit.checkAllVolumes();
                }
                if (copy) {
                    persistit.copyBackPages();
                }
                if (wait) {
                    persistit.setShutdownSuspended(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                persistit.setShutdownSuspended(false);
            }
            finally {
                persistit.close();
            }
        }
    }

    private class LogFlusher
    extends Thread {
        boolean _stop;

        LogFlusher() {
            this.setDaemon(true);
            this.setName("LOG_FLUSHER");
        }

        @Override
        public void run() {
            while (!this._stop) {
                try {
                    Util.sleep(5000L);
                }
                catch (PersistitInterruptedException ie) {
                    break;
                }
                Persistit.this.pollAlertMonitors(false);
                PersistitLogger logger = Persistit.this._logger;
                if (logger == null) continue;
                logger.flush();
            }
        }
    }

    public static class FatalErrorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        final String _threadName = Thread.currentThread().getName();
        final long _systemTime = System.currentTimeMillis();

        private FatalErrorException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

