/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.HandleCache;
import com.persistit.encoding.ValueCoder;
import com.persistit.encoding.ValueRenderer;
import com.persistit.exception.ConversionException;
import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class DefaultValueCoder
implements ValueRenderer,
HandleCache {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class[] OOS_CLASS_ARRAY = new Class[]{ObjectOutputStream.class};
    private static final Class[] OIS_CLASS_ARRAY = new Class[]{ObjectInputStream.class};
    private static final Comparator FIELD_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Field f1 = (Field)o1;
            Field f2 = (Field)o2;
            if (f1.getType().isPrimitive() && !f2.getType().isPrimitive()) {
                return -1;
            }
            return f1.getName().compareTo(f2.getName());
        }
    };
    private Class _clazz;
    private Persistit _persistit;
    private boolean _serializable;
    private boolean _externalizable;
    private ObjectStreamClass _classDescriptor;
    private Builder _valueBuilder;
    private Method _readResolveMethod = null;
    private Method _writeReplaceMethod = null;
    private Method _readObjectMethod = null;
    private Method _writeObjectMethod = null;
    private ValueRenderer _superClassValueRenderer = null;
    private static final String GET_14_NEW_INSTANCE_METHOD_NAME = "newInstance";
    private static final Class[] GET_14_NEW_INSTANCE_METHOD_TYPES = EMPTY_CLASS_ARRAY;
    private static final String GET_13_NEW_INSTANCE_METHOD_NAME = "allocateNewObject";
    private static final Class[] GET_13_NEW_INSTANCE_METHOD_TYPES = new Class[]{Class.class, Class.class};
    private Method _newInstanceMethod;
    private Object[] _newInstanceArguments;
    private Constructor _newInstanceConstructor;
    private volatile int _handle;

    public DefaultValueCoder(final Persistit persistit, final Class clientClass) throws SecurityException {
        this.init(persistit, clientClass, true);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Field[] fields;
                    ArrayList<Field> list;
                    if (DefaultValueCoder.this._classDescriptor != null) {
                        Object[] osFields = DefaultValueCoder.this._classDescriptor.getFields();
                        Arrays.sort(osFields);
                        list = new ArrayList<Field>(osFields.length);
                        for (int index = 0; index < osFields.length; ++index) {
                            String name = ((ObjectStreamField)osFields[index]).getName();
                            try {
                                Field field = clientClass.getDeclaredField(name);
                                list.add(field);
                                continue;
                            }
                            catch (NoSuchFieldException nsfe) {
                                throw new ConversionException(clientClass + " unmatched serializable field '" + name + "' declared");
                            }
                        }
                    } else {
                        fields = clientClass.getDeclaredFields();
                        Arrays.sort(fields, FIELD_COMPARATOR);
                        list = new ArrayList(fields.length);
                        for (int index = 0; index < fields.length; ++index) {
                            int modifier = fields[index].getModifiers();
                            if (Modifier.isTransient(modifier) || Modifier.isStatic(modifier)) continue;
                            list.add(fields[index]);
                        }
                    }
                    fields = list.toArray(new Field[list.size()]);
                    DefaultValueCoder.this._valueBuilder = new Builder("value", fields, clientClass);
                    DefaultValueCoder.this.lookupDefaultConstructor(persistit.getConfiguration().isConstructorOverride());
                    DefaultValueCoder.this.lookupSerializationMethods();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    public DefaultValueCoder(final Persistit persistit, final Class clientClass, final Field[] fields) {
        this.init(persistit, clientClass, false);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    DefaultValueCoder.this._valueBuilder = new Builder("value", fields, clientClass);
                    DefaultValueCoder.this.lookupDefaultConstructor(persistit.getConfiguration().isConstructorOverride());
                    DefaultValueCoder.this.lookupSerializationMethods();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    DefaultValueCoder(Persistit persistit, Class clientClass, final Builder valueBuilder) {
        this.init(persistit, clientClass, false);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    DefaultValueCoder.this._valueBuilder = valueBuilder;
                    DefaultValueCoder.this.lookupDefaultConstructor(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    private void init(Persistit persistit, Class clientClass, boolean mustBeSerializable) {
        this._clazz = clientClass;
        this._persistit = persistit;
        this._serializable = Serializable.class.isAssignableFrom(clientClass);
        if (this._serializable) {
            this._externalizable = Externalizable.class.isAssignableFrom(clientClass);
            this._classDescriptor = ObjectStreamClass.lookup(this._clazz);
        } else if (mustBeSerializable) {
            throw new ConversionException("Not Serializable: " + clientClass.getName());
        }
        Class superClass = clientClass.getSuperclass();
        if (superClass != null && Serializable.class.isAssignableFrom(superClass)) {
            ValueCoder coder = null;
            CoderManager cm = this._persistit.getCoderManager();
            if (cm != null) {
                coder = cm.lookupValueCoder(superClass);
            }
            if (!(coder instanceof DefaultValueCoder)) {
                coder = new DefaultValueCoder(persistit, superClass);
            }
            if (coder instanceof ValueRenderer) {
                this._superClassValueRenderer = (ValueRenderer)coder;
            }
        }
    }

    private void lookupDefaultConstructor(final boolean constructorOverride) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DefaultValueCoder.this._externalizable || !DefaultValueCoder.this._serializable || constructorOverride) {
                    Constructor constructor = null;
                    try {
                        constructor = DefaultValueCoder.this._clazz.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (DefaultValueCoder.this._externalizable && (constructor == null || !Modifier.isPublic(constructor.getModifiers()))) {
                        throw new ConversionException("Externalizable class " + DefaultValueCoder.this._clazz.getName() + " requires a public no-argument constructor");
                    }
                    if (constructor == null) {
                        throw new ConversionException("Class " + DefaultValueCoder.this._clazz.getName() + " requires a no-argument constructor");
                    }
                    constructor.setAccessible(true);
                    DefaultValueCoder.this._newInstanceConstructor = constructor;
                } else {
                    DefaultValueCoder.this._newInstanceMethod = null;
                    try {
                        DefaultValueCoder.this._newInstanceMethod = ObjectStreamClass.class.getDeclaredMethod(DefaultValueCoder.GET_14_NEW_INSTANCE_METHOD_NAME, GET_14_NEW_INSTANCE_METHOD_TYPES);
                        DefaultValueCoder.access$1202(DefaultValueCoder.this, EMPTY_OBJECT_ARRAY);
                    }
                    catch (NoSuchMethodException nsme) {
                        Class nonSerializableSuperclass;
                        for (nonSerializableSuperclass = DefaultValueCoder.this._clazz; nonSerializableSuperclass != null && Serializable.class.isAssignableFrom(nonSerializableSuperclass); nonSerializableSuperclass = nonSerializableSuperclass.getSuperclass()) {
                        }
                        try {
                            DefaultValueCoder.this._newInstanceMethod = ObjectInputStream.class.getDeclaredMethod(DefaultValueCoder.GET_13_NEW_INSTANCE_METHOD_NAME, GET_13_NEW_INSTANCE_METHOD_TYPES);
                            DefaultValueCoder.access$1202(DefaultValueCoder.this, new Class[]{DefaultValueCoder.this._clazz, nonSerializableSuperclass});
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (DefaultValueCoder.this._newInstanceMethod != null) {
                        DefaultValueCoder.this._newInstanceMethod.setAccessible(true);
                    } else {
                        throw new UnsupportedOperationException("Unable to find serialization constructor method for class " + DefaultValueCoder.this._clazz.getName());
                    }
                }
                return null;
            }
        });
    }

    public Class getClientClass() {
        return this._clazz;
    }

    private static Accessor lookupAccessor(Class clazz, String name) {
        String n;
        Method m;
        int index;
        char ch = name.charAt(0);
        String baseName = Character.isLetter(ch) && Character.isLowerCase(ch) ? new Character(Character.toUpperCase(ch)) + name.substring(1) : name;
        Method getMethod = null;
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        for (index = 0; index < methods.length; ++index) {
            m = methods[index];
            n = m.getName();
            if (n.startsWith("get") && n.regionMatches(3, baseName, 0, baseName.length()) && m.getParameterTypes().length == 0 && m.getReturnType() != Void.class && Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers())) {
                getMethod = m;
                continue;
            }
            if (!n.startsWith("is") || !n.regionMatches(2, baseName, 0, baseName.length()) || getMethod != null || m.getReturnType() != Boolean.TYPE || m.getParameterTypes().length != 1 || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers())) continue;
            getMethod = m;
        }
        if (getMethod != null) {
            for (index = 0; index < methods.length; ++index) {
                m = methods[index];
                n = m.getName();
                if (!n.startsWith("set") || !n.regionMatches(3, baseName, 0, baseName.length()) || m.getParameterTypes().length != 1 || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers())) continue;
                Class<?> c = m.getParameterTypes()[0];
                if (m.getReturnType() != Void.TYPE || c != getMethod.getReturnType()) continue;
                setMethod = m;
            }
        }
        if (getMethod != null && setMethod != null) {
            return new PropertyAccessor(getMethod, setMethod);
        }
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            Field field = DefaultValueCoder.lookupField(name, c);
            if (field == null || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            return DefaultValueCoder.accessorInstance(field);
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " has no accessible field or property named " + name);
    }

    private static Field lookupField(String name, Class clazz) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    private static Accessor accessorInstance(Field field) {
        Accessor accessor = null;
        accessor = field == null ? new NoFieldAccessor() : (field.getType().isPrimitive() ? (field.getType() == Boolean.TYPE ? new BooleanFieldAccessor() : (field.getType() == Byte.TYPE ? new ByteFieldAccessor() : (field.getType() == Short.TYPE ? new ShortFieldAccessor() : (field.getType() == Character.TYPE ? new CharFieldAccessor() : (field.getType() == Integer.TYPE ? new IntFieldAccessor() : (field.getType() == Long.TYPE ? new LongFieldAccessor() : (field.getType() == Float.TYPE ? new FloatFieldAccessor() : (field.getType() == Double.TYPE ? new DoubleFieldAccessor() : new ObjectFieldAccessor())))))))) : new ObjectFieldAccessor());
        accessor._field = field;
        return accessor;
    }

    private void lookupSerializationMethods() {
        if (this._serializable) {
            this._readResolveMethod = this.lookupInheritableMethod("readResolve", EMPTY_CLASS_ARRAY, Object.class);
            this._writeReplaceMethod = this.lookupInheritableMethod("writeReplace", EMPTY_CLASS_ARRAY, Object.class);
            if (!this._externalizable) {
                this._readObjectMethod = this.lookupPrivateMethod("readObject", OIS_CLASS_ARRAY, Void.TYPE);
                this._writeObjectMethod = this.lookupPrivateMethod("writeObject", OOS_CLASS_ARRAY, Void.TYPE);
            }
        }
    }

    private Method lookupPrivateMethod(String name, Class[] arguments, Class returnType) {
        Method method = null;
        try {
            method = this._clazz.getDeclaredMethod(name, arguments);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            int modifiers = method.getModifiers();
            if (method.getReturnType() == returnType && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers) && Modifier.isPrivate(modifiers)) {
                method.setAccessible(true);
                return method;
            }
        }
        return null;
    }

    private Method lookupInheritableMethod(String name, Class[] arguments, Class returnType) {
        Class cl = this._clazz;
        boolean privateOk = true;
        boolean packageOk = true;
        while (true) {
            Class scl;
            Method method = null;
            try {
                method = this._clazz.getDeclaredMethod(name, arguments);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method != null) {
                int modifiers = method.getModifiers();
                if (method.getReturnType() == returnType && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers) && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || privateOk && Modifier.isPrivate(modifiers) || packageOk && !Modifier.isPrivate(modifiers))) {
                    method.setAccessible(true);
                    return method;
                }
            }
            if ((scl = cl.getSuperclass()) == null || scl == Object.class) {
                return null;
            }
            if (!DefaultValueCoder.packageEquals(cl, scl)) {
                packageOk = false;
            }
            privateOk = false;
            cl = scl;
        }
    }

    private static boolean packageEquals(Class cl1, Class cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && DefaultValueCoder.getPackageName(cl1).equals(DefaultValueCoder.getPackageName(cl2));
    }

    private static String getPackageName(Class cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    private static void makeAccessorsAccessible(final Builder builder) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<AccessibleObject> list = new ArrayList<AccessibleObject>();
                Accessor[] accessors = builder._accessors;
                for (int index = 0; index < accessors.length; ++index) {
                    Accessor a = accessors[index];
                    if (a instanceof PropertyAccessor) {
                        PropertyAccessor pa = (PropertyAccessor)a;
                        if (pa._setMethod != null) {
                            list.add(pa._setMethod);
                        }
                        if (pa._getMethod == null) continue;
                        list.add(pa._getMethod);
                        continue;
                    }
                    list.add(a._field);
                }
                if (list.size() > 0) {
                    AccessibleObject.setAccessible(list.toArray(new AccessibleObject[list.size()]), true);
                }
                return null;
            }
        });
    }

    @Override
    public void put(Value value, Object object, CoderContext context) throws ConversionException {
        if (this._superClassValueRenderer != null) {
            this._superClassValueRenderer.put(value, object, context);
        }
        if (object instanceof Externalizable) {
            try {
                ((Externalizable)object).writeExternal(value.getObjectOutputStream());
            }
            catch (Exception e) {
                throw new ConversionException("Invoking writeExternal for " + this._clazz, e);
            }
        } else if (this._writeObjectMethod != null) {
            this.invokeMethod(value, this._writeObjectMethod, object, new Object[]{value.getObjectOutputStream()}, true);
        } else {
            this.putDefaultFields(value, object);
        }
    }

    Object writeReplace(Value value, Object object) {
        if (this._writeReplaceMethod != null) {
            return this.invokeMethod(value, this._writeReplaceMethod, object, EMPTY_OBJECT_ARRAY, false);
        }
        return object;
    }

    private Object invokeMethod(Value value, Method method, Object object, Object[] args, boolean setStackFields) throws ConversionException {
        DefaultValueCoder saveCoder = value.getCurrentCoder();
        Object saveObject = value.getCurrentObject();
        value.setCurrentCoder(setStackFields ? this : null);
        value.setCurrentObject(setStackFields ? object : null);
        try {
            Object result;
            Object object2 = result = method.invoke(object, args);
            return object2;
        }
        catch (Exception e) {
            throw new ConversionException("Invoking " + method + " for " + this._clazz, e);
        }
        finally {
            value.setCurrentCoder(saveCoder);
            value.setCurrentObject(saveObject);
        }
    }

    private Object invokeMethod(Method method, Object object, Object[] args, boolean setStackFields) throws ConversionException {
        try {
            Object result = method.invoke(object, args);
            return result;
        }
        catch (Exception e) {
            throw new ConversionException("Invoking " + method + " for " + this._clazz, e);
        }
    }

    Object newInstance() {
        try {
            if (this._newInstanceConstructor != null) {
                return this._newInstanceConstructor.newInstance(EMPTY_OBJECT_ARRAY);
            }
            if (this._newInstanceMethod != null) {
                return this._newInstanceMethod.invoke((Object)this._classDescriptor, this._newInstanceArguments);
            }
            return this._clazz.newInstance();
        }
        catch (Exception e) {
            throw new ConversionException("Instantiating " + this._clazz.getName(), e);
        }
    }

    public void putDefaultFields(Value value, Object object) throws ConversionException {
        Accessor accessor = null;
        try {
            Accessor[] accessors = this._valueBuilder._accessors;
            for (int index = 0; index < accessors.length; ++index) {
                accessor = accessors[index];
                accessors[index].toValue(object, value);
            }
        }
        catch (Exception e) {
            throw new ConversionException("Encoding " + accessor.toString() + " for " + this._clazz, e);
        }
    }

    public Object get(Value value, Class clazz, CoderContext context) throws ConversionException {
        if (clazz != this._clazz) {
            throw new ClassCastException("Client class " + this._clazz.getName() + " does not match requested class " + clazz.getName());
        }
        Object instance = this.newInstance();
        value.registerEncodedObject(instance);
        this.render(value, instance, clazz, context);
        return this.readResolve(value, instance);
    }

    Object readResolve(Value value, Object instance) {
        if (this._readResolveMethod != null) {
            instance = this.invokeMethod(value, this._readResolveMethod, instance, EMPTY_OBJECT_ARRAY, false);
        }
        return instance;
    }

    Object readResolve(Object instance) {
        if (this._readResolveMethod != null) {
            instance = this.invokeMethod(this._readResolveMethod, instance, EMPTY_OBJECT_ARRAY, false);
        }
        return instance;
    }

    public void render(Value value, Object target, Class clazz, CoderContext context) throws ConversionException {
        if (target == null) {
            throw new IllegalArgumentException("Target object must not be null");
        }
        if (this._superClassValueRenderer != null) {
            this._superClassValueRenderer.render(value, target, clazz.getSuperclass(), context);
        }
        if (target instanceof Externalizable) {
            try {
                ((Externalizable)target).readExternal(value.getObjectInputStream());
            }
            catch (Exception e) {
                throw new ConversionException("Invoking readExternal for " + this._clazz, e);
            }
        } else if (this._readObjectMethod != null) {
            this.invokeMethod(value, this._readObjectMethod, target, new Object[]{value.getObjectInputStream()}, true);
        } else {
            this.renderDefaultFields(value, target);
        }
    }

    void renderDefaultFields(Value value, Object target) throws ConversionException {
        Accessor accessor = null;
        try {
            Accessor[] accessors = this._valueBuilder._accessors;
            for (int index = 0; index < accessors.length; ++index) {
                accessor = accessors[index];
                accessor.fromValue(target, value);
            }
        }
        catch (Exception e) {
            throw new ConversionException("Decoding " + accessor.toString() + " for " + this._clazz, e);
        }
    }

    public Builder getValueBuilder() {
        return this._valueBuilder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultValueCoder(");
        sb.append(this._clazz.getName());
        sb.append(",");
        sb.append(this.getValueBuilder().toString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public synchronized void setHandle(int handle) {
        if (this._handle != 0 && this._handle != handle) {
            throw new IllegalStateException("Attempt to change handle from " + this._handle + " to " + handle);
        }
        this._handle = handle;
    }

    @Override
    public int getHandle() {
        return this._handle;
    }

    static /* synthetic */ Object[] access$1202(DefaultValueCoder x0, Object[] x1) {
        x0._newInstanceArguments = x1;
        return x1;
    }

    public static class Builder
    implements CoderContext {
        private static final long serialVersionUID = 1L;
        private final String _name;
        private final Accessor[] _accessors;
        private final String[] _accessorNames;

        Builder(String name, String[] accessorNames, Class clazz) {
            this._name = name;
            this._accessorNames = new String[accessorNames.length];
            System.arraycopy(accessorNames, 0, this._accessorNames, 0, accessorNames.length);
            this._accessors = new Accessor[accessorNames.length];
            for (int index = 0; index < accessorNames.length; ++index) {
                Accessor accessor;
                String accessorName = accessorNames[index];
                this._accessors[index] = accessor = DefaultValueCoder.lookupAccessor(clazz, accessorName);
            }
            DefaultValueCoder.makeAccessorsAccessible(this);
        }

        Builder(String name, Field[] fields, Class clazz) {
            this._name = name;
            this._accessorNames = new String[fields.length];
            this._accessors = new Accessor[fields.length];
            for (int index = 0; index < fields.length; ++index) {
                this._accessorNames[index] = fields[index].getName();
                this._accessors[index] = DefaultValueCoder.accessorInstance(fields[index]);
            }
            DefaultValueCoder.makeAccessorsAccessible(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this._name);
            sb.append("[");
            for (int index = 0; index < this._accessorNames.length; ++index) {
                if (index > 0) {
                    sb.append(",");
                }
                sb.append(this._accessorNames[index]);
                if (!(this._accessors[index] instanceof PropertyAccessor)) continue;
                sb.append("()");
            }
            sb.append("]");
            return sb.toString();
        }

        public String getName() {
            return this._name;
        }

        public int getSize() {
            return this._accessorNames.length;
        }

        Accessor getAccessor(int index) {
            return this._accessors[index];
        }

        public String getAccessorName(int index) {
            return this._accessorNames[index];
        }
    }

    private static final class NoFieldAccessor
    extends Accessor {
        private NoFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) {
        }

        @Override
        void fromValue(Object object, Value value) {
        }
    }

    private static final class DoubleFieldAccessor
    extends Accessor {
        private DoubleFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getDouble(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setDouble(object, value.getDouble());
        }
    }

    private static final class FloatFieldAccessor
    extends Accessor {
        private FloatFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getFloat(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setFloat(object, value.getFloat());
        }
    }

    private static final class LongFieldAccessor
    extends Accessor {
        private LongFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getLong(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setLong(object, value.getLong());
        }
    }

    private static final class IntFieldAccessor
    extends Accessor {
        private IntFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getInt(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setInt(object, value.getInt());
        }
    }

    private static final class CharFieldAccessor
    extends Accessor {
        private CharFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getChar(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setChar(object, value.getChar());
        }
    }

    private static final class ShortFieldAccessor
    extends Accessor {
        private ShortFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getShort(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setShort(object, value.getShort());
        }
    }

    private static final class ByteFieldAccessor
    extends Accessor {
        private ByteFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getByte(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setByte(object, value.getByte());
        }
    }

    private static final class BooleanFieldAccessor
    extends Accessor {
        private BooleanFieldAccessor() {
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            value.put(this._field.getBoolean(object));
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            this._field.setBoolean(object, value.getBoolean());
        }
    }

    private static class ObjectFieldAccessor
    extends Accessor {
        private ObjectFieldAccessor() {
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            Object arg = value.get(null, null);
            this._field.set(object, arg);
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            Object arg = this._field.get(object);
            value.put(arg);
        }
    }

    private static class PropertyAccessor
    extends Accessor {
        Method _getMethod;
        Method _setMethod;

        private PropertyAccessor(Method getMethod, Method setMethod) {
            this._getMethod = getMethod;
            this._setMethod = setMethod;
        }

        @Override
        public String toString() {
            return "Accessor[" + this._getMethod.getName() + "/" + this._setMethod.getName() + "]";
        }

        @Override
        void fromKey(Object object, Key key) throws Exception {
            Object arg = key.decode();
            this._setMethod.invoke(object, arg);
        }

        @Override
        void toKey(Object object, Key key) throws Exception {
            Object arg = null;
            arg = this._getMethod.invoke(object, EMPTY_OBJECT_ARRAY);
            key.append(arg);
        }

        @Override
        void fromValue(Object object, Value value) throws Exception {
            Object arg = value.get(null, null);
            this._setMethod.invoke(object, arg);
        }

        @Override
        void toValue(Object object, Value value) throws Exception {
            Object arg = this._getMethod.invoke(object, EMPTY_OBJECT_ARRAY);
            value.put(arg);
        }
    }

    static abstract class Accessor {
        Field _field;

        Accessor() {
        }

        public String toString() {
            return "Accessor[" + this._field.getName() + "]";
        }

        void fromKey(Object object, Key key) throws Exception {
            Object arg = key.decode();
            this._field.set(object, arg);
        }

        void toKey(Object object, Key key) throws Exception {
            Object arg = this._field.get(object);
            key.append(arg);
        }

        abstract void fromValue(Object var1, Value var2) throws Exception;

        abstract void toValue(Object var1, Value var2) throws Exception;

        protected void cantModifyFinalField() {
            throw new ConversionException("Can not modify final field " + this._field.getName());
        }
    }
}

