/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.oauth2.OAuth2;
import org.forgerock.http.oauth2.OAuth2Context;
import org.forgerock.http.oauth2.OAuth2Error;
import org.forgerock.http.oauth2.ResourceAccess;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.ResponseException;
import org.forgerock.http.protocol.Status;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.TimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServerFilter
implements Filter {
    static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String DESC_INVALID_TOKEN = "The access token provided is expired, revoked, malformed, or invalid for other reasons.";
    private static final String DESC_INVALID_REQUEST = "The request is missing a required parameter, includes an unsupported parameter or parameter value, repeats the same parameter, uses more than one method for including an access token, or is otherwise malformed.";
    private static final String DESC_INSUFFICIENT_SCOPE = "The request requires higher privileges than provided by the access token.";
    private static final Logger logger = LoggerFactory.getLogger(ResourceServerFilter.class);
    private final AccessTokenResolver resolver;
    private final TimeService time;
    private final ResourceAccess resourceAccess;
    private final String realm;

    private static Response notAuthorized(String realm) {
        return ResourceServerFilter.newResourceServerErrorResponse(Status.UNAUTHORIZED, realm, null, null, null);
    }

    private static Response invalidRequest(String realm, AccessTokenException cause) {
        Response response = ResourceServerFilter.newResourceServerErrorResponse(Status.BAD_REQUEST, realm, null, "invalid_request", DESC_INVALID_REQUEST);
        response.setCause((Exception)cause);
        return response;
    }

    private static Response invalidToken(String realm) {
        return ResourceServerFilter.newResourceServerErrorResponse(Status.UNAUTHORIZED, realm, null, "invalid_token", DESC_INVALID_TOKEN);
    }

    private static Response insufficientScope(String realm, Set<String> scopes) {
        return ResourceServerFilter.newResourceServerErrorResponse(Status.FORBIDDEN, realm, scopes, "insufficient_scope", DESC_INSUFFICIENT_SCOPE);
    }

    private static Response newResourceServerErrorResponse(Status status, String realm, Set<String> scopes, String error, String errorDesc) {
        Response response = new Response(status);
        OAuth2Error oAuth2Error = OAuth2Error.newResourceServerError(realm, scopes == null ? null : new ArrayList<String>(scopes), error, errorDesc, null);
        response.getHeaders().put(WWW_AUTHENTICATE_HEADER, (Object)oAuth2Error.toWWWAuthenticateHeader());
        return response;
    }

    public ResourceServerFilter(AccessTokenResolver resolver, TimeService time, ResourceAccess resourceAccess, String realm) {
        this.resolver = resolver;
        this.time = time;
        this.resourceAccess = resourceAccess;
        this.realm = realm;
    }

    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        String token;
        try {
            token = this.getAccessToken(request);
            if (token == null) {
                logger.debug("Missing OAuth 2.0 Bearer Token in the Authorization header");
                return Response.newResponsePromise((Response)ResourceServerFilter.notAuthorized(this.realm));
            }
        }
        catch (AccessTokenException e) {
            logger.debug("Multiple 'Authorization' headers in the request", (Throwable)e);
            return Response.newResponsePromise((Response)ResourceServerFilter.invalidRequest(this.realm, e));
        }
        return this.resolver.resolve(context, token).thenAsync(this.onResolverSuccess(context, request, next), this.onResolverException(token));
    }

    private AsyncFunction<AccessTokenException, Response, NeverThrowsException> onResolverException(final String token) {
        return new AsyncFunction<AccessTokenException, Response, NeverThrowsException>(){

            public Promise<? extends Response, ? extends NeverThrowsException> apply(AccessTokenException e) {
                logger.debug("Access Token '{}' cannot be resolved", (Object)token, (Object)e);
                return Response.newResponsePromise((Response)ResourceServerFilter.invalidToken(ResourceServerFilter.this.realm));
            }
        };
    }

    private AsyncFunction<AccessTokenInfo, Response, NeverThrowsException> onResolverSuccess(final Context context, final Request request, final Handler next) {
        return new AsyncFunction<AccessTokenInfo, Response, NeverThrowsException>(){

            public Promise<? extends Response, ? extends NeverThrowsException> apply(AccessTokenInfo accessToken) {
                if (ResourceServerFilter.this.isExpired(accessToken)) {
                    logger.debug("Access Token {} is expired", (Object)accessToken);
                    return Response.newResponsePromise((Response)ResourceServerFilter.invalidToken(ResourceServerFilter.this.realm));
                }
                try {
                    Set<String> scopesNeeded = ResourceServerFilter.this.resourceAccess.getRequiredScopes(context, request);
                    if (!accessToken.getScopes().containsAll(scopesNeeded)) {
                        logger.debug("Access Token {} is missing required scopes", (Object)accessToken);
                        return Response.newResponsePromise((Response)ResourceServerFilter.insufficientScope(ResourceServerFilter.this.realm, scopesNeeded));
                    }
                }
                catch (ResponseException e) {
                    return Response.newResponsePromise((Response)e.getResponse());
                }
                return next.handle((Context)new OAuth2Context(context, accessToken), request);
            }
        };
    }

    private boolean isExpired(AccessTokenInfo accessToken) {
        return this.time.now() > accessToken.getExpiresAt();
    }

    private String getAccessToken(Request request) throws AccessTokenException {
        Headers headers = request.getHeaders();
        Header authHeader = headers.get((Object)AUTHORIZATION_HEADER);
        if (authHeader == null) {
            return null;
        }
        List authorizations = authHeader.getValues();
        if (authorizations.size() > 1) {
            throw new AccessTokenException("Can't use more than 1 'Authorization' Header to convey the OAuth2 AccessToken");
        }
        return OAuth2.getBearerAccessToken(headers.getFirst(AUTHORIZATION_HEADER));
    }
}

