/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.util.encode.Base64;

class HmacCalculator {
    private SecretKey currentKey;
    private final MessageDigest messageDigest;
    private final Mac mac;
    private final String hmacAlgorithm;

    public HmacCalculator(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-256");
            this.mac = Mac.getInstance(hmacAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    SecretKey getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(byte[] bytes) {
        this.currentKey = new SecretKeySpec(bytes, this.hmacAlgorithm);
    }

    public String calculate(byte[] data) throws SignatureException {
        try {
            this.mac.reset();
            this.mac.init(this.currentKey);
            byte[] rawHmac = this.mac.doFinal(data);
            String result = Base64.encode((byte[])rawHmac);
            this.computeNextKeyIteration();
            return result;
        }
        catch (IllegalStateException | InvalidKeyException e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    private void computeNextKeyIteration() {
        this.messageDigest.reset();
        this.messageDigest.update(this.currentKey.getEncoded());
        this.currentKey = new SecretKeySpec(this.messageDigest.digest(), this.messageDigest.getAlgorithm());
    }
}

